/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.clusterregistry.client.apis;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.alauda.devops.java.clusterregistry.client.models.V1alpha1Cluster;
import io.alauda.devops.java.clusterregistry.client.models.V1alpha1ClusterList;
import io.kubernetes.client.ApiCallback;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.ApiResponse;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.ProgressRequestBody;
import io.kubernetes.client.ProgressResponseBody;
import io.kubernetes.client.models.V1APIResourceList;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1Status;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ClusterregistryK8sIoV1alpha1Api {
    private ApiClient apiClient;

    public ClusterregistryK8sIoV1alpha1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ClusterregistryK8sIoV1alpha1Api(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createNamespacedClusterCall(String namespace, V1alpha1Cluster body, Boolean includeUninitialized, String pretty, String dryRun, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1alpha1Cluster localVarPostBody = body;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/namespaces/{namespace}/clusters".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (includeUninitialized != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeUninitialized", (Object)includeUninitialized));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", (Object)dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createNamespacedClusterValidateBeforeCall(String namespace, V1alpha1Cluster body, Boolean includeUninitialized, String pretty, String dryRun, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedCluster(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedCluster(Async)");
        }
        Call call = this.createNamespacedClusterCall(namespace, body, includeUninitialized, pretty, dryRun, progressListener, progressRequestListener);
        return call;
    }

    public V1alpha1Cluster createNamespacedCluster(String namespace, V1alpha1Cluster body, Boolean includeUninitialized, String pretty, String dryRun) throws ApiException {
        ApiResponse<V1alpha1Cluster> resp = this.createNamespacedClusterWithHttpInfo(namespace, body, includeUninitialized, pretty, dryRun);
        return (V1alpha1Cluster)resp.getData();
    }

    public ApiResponse<V1alpha1Cluster> createNamespacedClusterWithHttpInfo(String namespace, V1alpha1Cluster body, Boolean includeUninitialized, String pretty, String dryRun) throws ApiException {
        Call call = this.createNamespacedClusterValidateBeforeCall(namespace, body, includeUninitialized, pretty, dryRun, null, null);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createNamespacedClusterAsync(String namespace, V1alpha1Cluster body, Boolean includeUninitialized, String pretty, String dryRun, final ApiCallback<V1alpha1Cluster> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createNamespacedClusterValidateBeforeCall(namespace, body, includeUninitialized, pretty, dryRun, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCollectionNamespacedClusterCall(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/namespaces/{namespace}/clusters".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (includeUninitialized != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeUninitialized", (Object)includeUninitialized));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("continue", (Object)_continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", (Object)fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", (Object)labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", (Object)limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", (Object)resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", (Object)timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", (Object)watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCollectionNamespacedClusterValidateBeforeCall(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedCluster(Async)");
        }
        Call call = this.deleteCollectionNamespacedClusterCall(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V1Status deleteCollectionNamespacedCluster(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1Status> resp = this.deleteCollectionNamespacedClusterWithHttpInfo(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch);
        return (V1Status)resp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionNamespacedClusterWithHttpInfo(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.deleteCollectionNamespacedClusterValidateBeforeCall(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteCollectionNamespacedClusterAsync(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V1Status> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCollectionNamespacedClusterValidateBeforeCall(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteNamespacedClusterCall(String name, String namespace, V1DeleteOptions body, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/namespaces/{namespace}/clusters/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", (Object)dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("gracePeriodSeconds", (Object)gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orphanDependents", (Object)orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("propagationPolicy", (Object)propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteNamespacedClusterValidateBeforeCall(String name, String namespace, V1DeleteOptions body, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedCluster(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedCluster(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteNamespacedCluster(Async)");
        }
        Call call = this.deleteNamespacedClusterCall(name, namespace, body, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        return call;
    }

    public V1Status deleteNamespacedCluster(String name, String namespace, V1DeleteOptions body, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        ApiResponse<V1Status> resp = this.deleteNamespacedClusterWithHttpInfo(name, namespace, body, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy);
        return (V1Status)resp.getData();
    }

    public ApiResponse<V1Status> deleteNamespacedClusterWithHttpInfo(String name, String namespace, V1DeleteOptions body, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        Call call = this.deleteNamespacedClusterValidateBeforeCall(name, namespace, body, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, null, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteNamespacedClusterAsync(String name, String namespace, V1DeleteOptions body, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ApiCallback<V1Status> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteNamespacedClusterValidateBeforeCall(name, namespace, body, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAPIResourcesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAPIResourcesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAPIResourcesCall(progressListener, progressRequestListener);
        return call;
    }

    public V1APIResourceList getAPIResources() throws ApiException {
        ApiResponse<V1APIResourceList> resp = this.getAPIResourcesWithHttpInfo();
        return (V1APIResourceList)resp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call call = this.getAPIResourcesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAPIResourcesAsync(final ApiCallback<V1APIResourceList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAPIResourcesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listClusterForAllNamespacesCall(String _continue, String fieldSelector, Boolean includeUninitialized, String labelSelector, Integer limit, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/clusters";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (_continue != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("continue", (Object)_continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", (Object)fieldSelector));
        }
        if (includeUninitialized != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeUninitialized", (Object)includeUninitialized));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", (Object)labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", (Object)limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", (Object)resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", (Object)timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", (Object)watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listClusterForAllNamespacesValidateBeforeCall(String _continue, String fieldSelector, Boolean includeUninitialized, String labelSelector, Integer limit, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listClusterForAllNamespacesCall(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V1alpha1ClusterList listClusterForAllNamespaces(String _continue, String fieldSelector, Boolean includeUninitialized, String labelSelector, Integer limit, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha1ClusterList> resp = this.listClusterForAllNamespacesWithHttpInfo(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch);
        return (V1alpha1ClusterList)resp.getData();
    }

    public ApiResponse<V1alpha1ClusterList> listClusterForAllNamespacesWithHttpInfo(String _continue, String fieldSelector, Boolean includeUninitialized, String labelSelector, Integer limit, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listClusterForAllNamespacesValidateBeforeCall(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V1alpha1ClusterList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listClusterForAllNamespacesAsync(String _continue, String fieldSelector, Boolean includeUninitialized, String labelSelector, Integer limit, String pretty, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V1alpha1ClusterList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listClusterForAllNamespacesValidateBeforeCall(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1alpha1ClusterList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listNamespacedClusterCall(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/namespaces/{namespace}/clusters".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (includeUninitialized != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeUninitialized", (Object)includeUninitialized));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("continue", (Object)_continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldSelector", (Object)fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", (Object)labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", (Object)limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", (Object)resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", (Object)timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", (Object)watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listNamespacedClusterValidateBeforeCall(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedCluster(Async)");
        }
        Call call = this.listNamespacedClusterCall(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public V1alpha1ClusterList listNamespacedCluster(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha1ClusterList> resp = this.listNamespacedClusterWithHttpInfo(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch);
        return (V1alpha1ClusterList)resp.getData();
    }

    public ApiResponse<V1alpha1ClusterList> listNamespacedClusterWithHttpInfo(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listNamespacedClusterValidateBeforeCall(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<V1alpha1ClusterList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listNamespacedClusterAsync(String namespace, Boolean includeUninitialized, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<V1alpha1ClusterList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listNamespacedClusterValidateBeforeCall(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1alpha1ClusterList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedClusterCall(String name, String namespace, Object body, String pretty, String dryRun, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/namespaces/{namespace}/clusters/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", (Object)dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedClusterValidateBeforeCall(String name, String namespace, Object body, String pretty, String dryRun, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCluster(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCluster(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCluster(Async)");
        }
        Call call = this.patchNamespacedClusterCall(name, namespace, body, pretty, dryRun, progressListener, progressRequestListener);
        return call;
    }

    public V1alpha1Cluster patchNamespacedCluster(String name, String namespace, Object body, String pretty, String dryRun) throws ApiException {
        ApiResponse<V1alpha1Cluster> resp = this.patchNamespacedClusterWithHttpInfo(name, namespace, body, pretty, dryRun);
        return (V1alpha1Cluster)resp.getData();
    }

    public ApiResponse<V1alpha1Cluster> patchNamespacedClusterWithHttpInfo(String name, String namespace, Object body, String pretty, String dryRun) throws ApiException {
        Call call = this.patchNamespacedClusterValidateBeforeCall(name, namespace, body, pretty, dryRun, null, null);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedClusterAsync(String name, String namespace, Object body, String pretty, String dryRun, final ApiCallback<V1alpha1Cluster> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedClusterValidateBeforeCall(name, namespace, body, pretty, dryRun, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readNamespacedClusterCall(String name, String namespace, String pretty, Boolean exact, Boolean export, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/namespaces/{namespace}/clusters/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (exact != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("exact", (Object)exact));
        }
        if (export != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("export", (Object)export));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readNamespacedClusterValidateBeforeCall(String name, String namespace, String pretty, Boolean exact, Boolean export, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedCluster(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedCluster(Async)");
        }
        Call call = this.readNamespacedClusterCall(name, namespace, pretty, exact, export, progressListener, progressRequestListener);
        return call;
    }

    public V1alpha1Cluster readNamespacedCluster(String name, String namespace, String pretty, Boolean exact, Boolean export) throws ApiException {
        ApiResponse<V1alpha1Cluster> resp = this.readNamespacedClusterWithHttpInfo(name, namespace, pretty, exact, export);
        return (V1alpha1Cluster)resp.getData();
    }

    public ApiResponse<V1alpha1Cluster> readNamespacedClusterWithHttpInfo(String name, String namespace, String pretty, Boolean exact, Boolean export) throws ApiException {
        Call call = this.readNamespacedClusterValidateBeforeCall(name, namespace, pretty, exact, export, null, null);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readNamespacedClusterAsync(String name, String namespace, String pretty, Boolean exact, Boolean export, final ApiCallback<V1alpha1Cluster> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readNamespacedClusterValidateBeforeCall(name, namespace, pretty, exact, export, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedClusterCall(String name, String namespace, V1alpha1Cluster body, String pretty, String dryRun, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1alpha1Cluster localVarPostBody = body;
        String localVarPath = "/apis/clusterregistry.k8s.io/v1alpha1/namespaces/{namespace}/clusters/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", (Object)pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", (Object)dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedClusterValidateBeforeCall(String name, String namespace, V1alpha1Cluster body, String pretty, String dryRun, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCluster(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCluster(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCluster(Async)");
        }
        Call call = this.replaceNamespacedClusterCall(name, namespace, body, pretty, dryRun, progressListener, progressRequestListener);
        return call;
    }

    public V1alpha1Cluster replaceNamespacedCluster(String name, String namespace, V1alpha1Cluster body, String pretty, String dryRun) throws ApiException {
        ApiResponse<V1alpha1Cluster> resp = this.replaceNamespacedClusterWithHttpInfo(name, namespace, body, pretty, dryRun);
        return (V1alpha1Cluster)resp.getData();
    }

    public ApiResponse<V1alpha1Cluster> replaceNamespacedClusterWithHttpInfo(String name, String namespace, V1alpha1Cluster body, String pretty, String dryRun) throws ApiException {
        Call call = this.replaceNamespacedClusterValidateBeforeCall(name, namespace, body, pretty, dryRun, null, null);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedClusterAsync(String name, String namespace, V1alpha1Cluster body, String pretty, String dryRun, final ApiCallback<V1alpha1Cluster> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedClusterValidateBeforeCall(name, namespace, body, pretty, dryRun, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1alpha1Cluster>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

