/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.clusterregistry.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.clusterregistry.client.models.V1alpha1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="AuthInfo holds information that describes how a client can get credentials to access the cluster. For example, OAuth2 client registration endpoints and supported flows, or Kerberos server locations.")
public class V1alpha1ClusterAuthInfo {
    @SerializedName(value="user")
    private V1alpha1ObjectReference user = null;
    @SerializedName(value="controller")
    private V1alpha1ObjectReference controller = null;

    public V1alpha1ClusterAuthInfo user(V1alpha1ObjectReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="User references an object that contains implementation-specific details about how a user should authenticate against this cluster.")
    public V1alpha1ObjectReference getUser() {
        return this.user;
    }

    public void setUser(V1alpha1ObjectReference user) {
        this.user = user;
    }

    public V1alpha1ClusterAuthInfo controller(V1alpha1ObjectReference controller) {
        this.controller = controller;
        return this;
    }

    @ApiModelProperty(value="Controller references an object that contains implementation-specific details about how a controller should authenticate. A simple use case for this would be to reference a secret in another namespace that stores a bearer token that can be used to authenticate against this cluster's API server.")
    public V1alpha1ObjectReference getController() {
        return this.controller;
    }

    public void setController(V1alpha1ObjectReference controller) {
        this.controller = controller;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ClusterAuthInfo v1alpha1ClusterAuthInfo = (V1alpha1ClusterAuthInfo)o;
        return Objects.equals(this.user, v1alpha1ClusterAuthInfo.user) && Objects.equals(this.controller, v1alpha1ClusterAuthInfo.controller);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.controller);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ClusterAuthInfo {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    controller: ").append(this.toIndentedString(this.controller)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

