/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.type.ValueType;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class ValueBridge {
    public static void setStatement(PreparedStatement pstmt, int i, ValueType type, Object value) throws SQLException {
        switch (type) {
            case BYTE: {
                pstmt.setByte(i, (Byte)value);
                break;
            }
            case STRING: {
                pstmt.setString(i, (String)value);
                break;
            }
            case BOOLEAN3: 
            case BOOLEAN: {
                pstmt.setBoolean(i, (Boolean)value);
                break;
            }
            case INTEGER: {
                pstmt.setInt(i, (Integer)value);
                break;
            }
            case LONG: {
                pstmt.setLong(i, (Long)value);
                break;
            }
            case SHORT: {
                pstmt.setShort(i, (Short)value);
                break;
            }
            case FLOAT: {
                pstmt.setFloat(i, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                pstmt.setDouble(i, (Double)value);
                break;
            }
            case BIGDECIMAL: {
                pstmt.setBigDecimal(i, (BigDecimal)value);
                break;
            }
            case ARRAY: {
                pstmt.setArray(i, (Array)value);
                break;
            }
            case BYTEARRAY: {
                pstmt.setBytes(i, (byte[])value);
                break;
            }
            case BLOB: {
                pstmt.setBlob(i, (Blob)value);
                break;
            }
            case CLOB: {
                pstmt.setClob(i, (Clob)value);
                break;
            }
            case READER: {
                pstmt.setCharacterStream(i, (Reader)value);
                break;
            }
            case STREAM: {
                pstmt.setBinaryStream(i, (InputStream)value);
                break;
            }
            case TIME: {
                pstmt.setTime(i, (Time)value);
                break;
            }
            case TIMESTAMP: {
                pstmt.setTimestamp(i, (Timestamp)value);
                break;
            }
            case SQLDATE: {
                pstmt.setDate(i, (Date)value);
                break;
            }
            case DATE: {
                Date date = value == null ? null : new Date(((java.util.Date)value).getTime());
                pstmt.setDate(i, date);
                break;
            }
            case CALENDAR: {
                Date calDate = value == null ? null : new Date(((Calendar)value).getTime().getTime());
                pstmt.setDate(i, calDate);
                break;
            }
            case URL: {
                pstmt.setURL(i, (URL)value);
            }
        }
    }

    public static void setField(Object entity, Field field, ValueType type, String columnName, ResultSet resultSet) throws IllegalAccessException, SQLException {
        switch (type) {
            case BYTE: {
                field.setByte(entity, resultSet.getByte(columnName));
                break;
            }
            case STRING: {
                field.set(entity, resultSet.getString(columnName));
                break;
            }
            case BOOLEAN3: {
                field.set(entity, resultSet.getObject(columnName));
                break;
            }
            case BOOLEAN: {
                field.setBoolean(entity, resultSet.getBoolean(columnName));
                break;
            }
            case INTEGER: {
                int intVal = resultSet.getInt(columnName);
                field.set(entity, intVal == 0 ? null : Integer.valueOf(intVal));
                break;
            }
            case LONG: {
                long longVal = resultSet.getLong(columnName);
                field.set(entity, longVal == 0L ? null : Long.valueOf(longVal));
                break;
            }
            case SHORT: {
                short shortVal = resultSet.getShort(columnName);
                field.set(entity, shortVal == 0 ? null : Short.valueOf(shortVal));
                break;
            }
            case FLOAT: {
                float floatVal = resultSet.getFloat(columnName);
                field.set(entity, floatVal == 0.0f ? null : Float.valueOf(floatVal));
                break;
            }
            case DOUBLE: {
                double doubleVal = resultSet.getDouble(columnName);
                field.set(entity, doubleVal == 0.0 ? null : Double.valueOf(doubleVal));
                break;
            }
            case BIGDECIMAL: {
                field.set(entity, resultSet.getBigDecimal(columnName));
                break;
            }
            case ARRAY: {
                field.set(entity, resultSet.getArray(columnName));
                break;
            }
            case BYTEARRAY: {
                field.set(entity, resultSet.getBytes(columnName));
                break;
            }
            case BLOB: {
                field.set(entity, resultSet.getBlob(columnName));
                break;
            }
            case CLOB: {
                field.set(entity, resultSet.getClob(columnName));
                break;
            }
            case READER: {
                field.set(entity, resultSet.getCharacterStream(columnName));
                break;
            }
            case STREAM: {
                field.set(entity, resultSet.getBinaryStream(columnName));
                break;
            }
            case TIME: {
                field.set(entity, resultSet.getTime(columnName));
                break;
            }
            case TIMESTAMP: {
                field.set(entity, resultSet.getTimestamp(columnName));
                break;
            }
            case SQLDATE: {
                field.set(entity, resultSet.getDate(columnName));
                break;
            }
            case DATE: {
                field.set(entity, resultSet.getDate(columnName));
                break;
            }
            case CALENDAR: {
                Date calDate = resultSet.getDate(columnName);
                Calendar calVal = Calendar.getInstance();
                calVal.setTime(calDate);
                field.set(entity, calVal);
                break;
            }
            case URL: {
                field.set(entity, resultSet.getURL(columnName));
            }
        }
    }
}

