/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.AbstractTable;
import io.advant.orm.DBConnection;
import io.advant.orm.Entity;
import io.advant.orm.exception.TableParseException;
import io.advant.orm.exception.UnsynchronizedException;
import io.advant.orm.internal.ColumnData;
import io.advant.orm.internal.Condition;
import io.advant.orm.internal.Conditions;
import io.advant.orm.internal.CustomStatement;
import io.advant.orm.internal.EntityReflect;
import io.advant.orm.internal.JoinData;
import io.advant.orm.internal.ValueBridge;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class SqlProcessor {
    private static final Logger LOGGER = Logger.getLogger(SqlProcessor.class.getName());
    private final EntityReflect<? extends Entity> reflect;
    private final Connection connection;
    private final CustomStatement customStatement;
    private PreparedStatement pstmt;

    public SqlProcessor(DBConnection connection, EntityReflect<? extends Entity> reflect) {
        this.connection = connection;
        this.reflect = reflect;
        this.customStatement = new CustomStatement(connection);
    }

    public int deleteAll() throws SQLException {
        String sql = "DELETE FROM " + this.reflect.getTable();
        this.pstmt = this.connection.prepareStatement(sql);
        return this.pstmt.executeUpdate();
    }

    public ResultSet select(Conditions conditions) throws SQLException, NoSuchFieldException, TableParseException {
        String select = "SELECT";
        String from = "FROM " + this.reflect.getTable();
        String join = "";
        HashSet<ColumnData> columns = new HashSet<ColumnData>();
        columns.addAll(this.reflect.getColumns());
        this.getTableColumnsForSelect(columns, this.reflect);
        ArrayList<JoinData> joins = new ArrayList<JoinData>();
        this.getJoinsForSelect(this.reflect, joins, new JoinData(null, null, this.reflect.getTable(), null));
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            ColumnData column = (ColumnData)iterator.next();
            boolean isLastColumn = !iterator.hasNext() && !iterator.hasNext();
            select = select + " " + column.getTable() + "." + column.getColumn() + " AS " + column.getTableIndex() + "_" + column.getColumn() + (isLastColumn ? " " : ",");
        }
        for (JoinData joinData : joins) {
            join = join + " LEFT JOIN " + joinData.getJoinTable() + " ON " + joinData.getJoinTable() + "." + joinData.getJoinColumn() + "=" + joinData.getTable() + "." + joinData.getColumn();
        }
        String where = conditions != null ? " WHERE " + conditions.asSQL() + " " : "";
        String sql = select + from + join + where;
        LOGGER.fine(sql);
        this.pstmt = this.connection.prepareStatement(sql);
        if (conditions != null) {
            int i = 0;
            for (Condition condition : conditions.getList()) {
                this.pstmt.setObject(++i, condition.getValue());
            }
        }
        return this.pstmt.executeQuery();
    }

    private void getTableColumnsForSelect(Set<ColumnData> columns, EntityReflect<? extends Entity> entityReflect) throws TableParseException, NoSuchFieldException {
        for (Class joinEntitiyClass : entityReflect.getJoinEntities().values()) {
            EntityReflect joinEntityReflect = EntityReflect.getInstance(joinEntitiyClass);
            columns.addAll(joinEntityReflect.getColumns());
            this.getTableColumnsForSelect(columns, joinEntityReflect);
        }
    }

    private void getJoinsForSelect(EntityReflect<? extends Entity> reflect, List<JoinData> joins, JoinData doNotJoin) throws TableParseException, NoSuchFieldException {
        for (JoinData join : reflect.getJoins()) {
            if (joins.contains(join) || join.equals(doNotJoin)) continue;
            joins.add(join);
        }
        for (Class joinEntityClass : reflect.getJoinEntities().values()) {
            EntityReflect joinEntityReflect = EntityReflect.getInstance(joinEntityClass);
            this.getJoinsForSelect(joinEntityReflect, joins, doNotJoin);
        }
    }

    public <T extends Entity> void insert(T entity, List<ColumnData> columnsData) throws SQLException, IllegalAccessException {
        Object id;
        String sql = "INSERT INTO " + this.reflect.getTable();
        String columns = " (";
        String values = " (";
        for (ColumnData columnData : columnsData) {
            if (columnData.isId() && columnData.getValue() == null) continue;
            columns = columns + columnData.getColumn() + ",";
            values = values + "?,";
        }
        columns = columns.substring(0, columns.length() - 1) + ")";
        values = values.substring(0, values.length() - 1) + ")";
        sql = sql + columns + " VALUES " + values;
        this.pstmt = this.customStatement.forInsert(sql);
        int i = 0;
        for (ColumnData columnData : columnsData) {
            Object value = columnData.getValue();
            if (columnData.isId() && columnData.getValue() == null) continue;
            if (columnData.isVersion()) {
                value = 1L;
            }
            ValueBridge.setStatement(this.pstmt, ++i, columnData.getValueType(), value);
        }
        entity.setVersion(1L);
        this.pstmt.executeUpdate();
        ResultSet resultSet = this.pstmt.getGeneratedKeys();
        if (entity.getId() == null && resultSet.next() && (id = resultSet.getObject(1)) instanceof Number) {
            entity.setId(((Number)id).longValue());
        }
        resultSet.close();
    }

    public <T extends Entity> int update(T entity, List<ColumnData> columnsData) throws IllegalAccessException, SQLException, UnsynchronizedException {
        String sql = "UPDATE " + this.reflect.getTable() + " SET ";
        Long id = null;
        for (ColumnData columnData : columnsData) {
            if (columnData.isId()) {
                id = (Long)columnData.getValue();
                continue;
            }
            sql = sql + columnData.getColumn() + " = ?,";
        }
        if (id == null) {
            throw new UnsynchronizedException();
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + " WHERE id = ?";
        this.pstmt = this.connection.prepareStatement(sql);
        int i = 0;
        for (ColumnData columnData : columnsData) {
            if (columnData.isId()) continue;
            if (columnData.isVersion()) {
                Long version = (Long)columnData.getValue();
                if (version == null) {
                    throw new UnsynchronizedException();
                }
                version = version + 1L;
                this.pstmt.setLong(++i, version);
                entity.setVersion(version);
                continue;
            }
            ValueBridge.setStatement(this.pstmt, ++i, columnData.getValueType(), columnData.getValue());
        }
        Long l = ((AbstractTable)((Object)entity)).getLastId();
        id = l == null ? id : l;
        this.pstmt.setLong(++i, id);
        return this.pstmt.executeUpdate();
    }

    public <T extends Entity> int delete(T entity) throws SQLException, UnsynchronizedException {
        String sql = "DELETE FROM " + this.reflect.getTable() + " WHERE id=?";
        this.pstmt = this.connection.prepareStatement(sql);
        Long id = entity.getId();
        if (id == null) {
            throw new UnsynchronizedException();
        }
        this.pstmt.setObject(1, id);
        return this.pstmt.executeUpdate();
    }

    public int delete(Conditions conditions) throws SQLException {
        String sql = "DELETE FROM " + this.reflect.getTable();
        if (conditions == null) {
            return this.deleteAll();
        }
        sql = sql + " WHERE " + conditions.asSQL() + " ";
        this.pstmt = this.connection.prepareStatement(sql);
        int i = 0;
        for (Condition condition : conditions.getList()) {
            this.pstmt.setObject(++i, condition.getValue());
        }
        return this.pstmt.executeUpdate();
    }

    public void close() throws SQLException {
        if (this.pstmt != null) {
            this.pstmt.close();
        }
    }
}

