/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.internal.SqlProcessor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class ExecuteUpdate {
    private static final Logger LOGGER = Logger.getLogger(SqlProcessor.class.getName());

    public static int run(Connection connection, String sql) throws SQLException {
        Statement stmt = connection.createStatement();
        int row = stmt.executeUpdate(sql);
        stmt.close();
        return row;
    }

    public static int run(Connection connection, String sql, Object[] values) throws SQLException {
        PreparedStatement pstmt = connection.prepareStatement(sql);
        int i = 0;
        for (Object value : values) {
            pstmt.setObject(++i, value);
        }
        int row = pstmt.executeUpdate(sql);
        pstmt.close();
        return row;
    }

    public static void run(Connection connection, String[] queries) throws SQLException {
        Statement stmt = connection.createStatement();
        for (String query : queries) {
            stmt.execute(query);
        }
        stmt.close();
    }

    public static boolean call(Connection connection, String sql) throws SQLException {
        CallableStatement cstmt = connection.prepareCall(sql);
        boolean result = cstmt.execute();
        cstmt.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Connection connection, String[] array, boolean exitOnError) throws SQLException {
        StringBuffer command = null;
        String delimiter = ";";
        int lineNumber = 0;
        for (String line : array) {
            String trimmedLine;
            ++lineNumber;
            if (line.isEmpty()) continue;
            if (command == null) {
                command = new StringBuffer();
            }
            if ((trimmedLine = line.trim()).length() < 1 || trimmedLine.startsWith("//") || trimmedLine.startsWith("--")) continue;
            if (!trimmedLine.isEmpty() && trimmedLine.endsWith(delimiter)) {
                command.append(line.substring(0, line.lastIndexOf(delimiter)));
                command.append(" ");
                try (Statement statement = connection.createStatement();){
                    statement.execute(command.toString());
                }
                command = null;
                continue;
            }
            command.append(line);
        }
    }
}

