/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.annotation.Column;
import io.advant.orm.annotation.Relation;
import io.advant.orm.annotation.Table;
import io.advant.orm.exception.TableParseException;
import io.advant.orm.internal.ColumnData;
import io.advant.orm.internal.JoinData;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityReflect<T> {
    private static Map<Class<?>, EntityReflect> instance = new HashMap();
    private static int num = 0;
    private final Class<T> entityClass;
    private final String tableIndex;
    private final Class<? super T> tableClass;
    private final Class<? super T> superTableClass;
    private final String table;
    private Field idField;
    private Set<JoinData> joins = new HashSet<JoinData>();
    private Set<ColumnData> columns = new HashSet<ColumnData>();
    private Map<Field, Class> joinEntities = new HashMap<Field, Class>();

    private EntityReflect(Class<T> entityClass, int tableIndex) throws TableParseException, NoSuchFieldException {
        this.entityClass = entityClass;
        this.tableIndex = "t" + tableIndex;
        this.tableClass = this.getTableFromEntity(entityClass);
        this.superTableClass = this.tableClass.getSuperclass();
        this.table = this.tableClass.getAnnotation(Table.class).name();
        this.parseTable();
        this.parseEntity();
    }

    public static <T> EntityReflect<T> getInstance(Class<T> clazz) throws TableParseException, NoSuchFieldException {
        EntityReflect<T> current = instance.get(clazz);
        if (current == null) {
            current = new EntityReflect<T>(clazz, ++num);
            instance.put(clazz, current);
        }
        return current;
    }

    private void parseEntity() throws NoSuchFieldException, TableParseException {
        for (Field field : this.entityClass.getDeclaredFields()) {
            Class joinEntityClass;
            field.setAccessible(true);
            Relation annotRelation = field.getAnnotation(Relation.class);
            if (annotRelation == null) continue;
            if (field.getType().equals(List.class) || field.getType().equals(Set.class)) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                joinEntityClass = (Class)genericType.getActualTypeArguments()[0];
            } else {
                joinEntityClass = field.getType();
            }
            Class joinTableClass = this.getTableFromEntity(joinEntityClass);
            Table annotJoinTable = joinTableClass.getAnnotation(Table.class);
            String joinTable = annotJoinTable.name();
            String column = this.getColumnFromTable(this.tableClass, annotRelation.from());
            String joinColumn = this.getColumnFromTable(joinTableClass, annotRelation.to());
            JoinData joinData = new JoinData(this.table, column, joinTable, joinColumn);
            this.joins.add(joinData);
            this.joinEntities.put(field, joinEntityClass);
        }
    }

    private String getColumnFromTable(Class tableClass, String property) throws NoSuchFieldException {
        Field field = property.equals("id") || property.equals("version") ? tableClass.getSuperclass().getDeclaredField(property) : tableClass.getDeclaredField(property);
        field.setAccessible(true);
        return field.getAnnotation(Column.class).name();
    }

    private void parseTable() throws NoSuchFieldException {
        for (Field field : this.tableClass.getDeclaredFields()) {
            field.setAccessible(true);
            Column annotColumn = field.getAnnotation(Column.class);
            String column = annotColumn.name();
            ColumnData columnData = new ColumnData(false, false, column, this.table, this.tableIndex, field);
            this.columns.add(columnData);
        }
        this.idField = this.superTableClass.getDeclaredField("id");
        this.idField.setAccessible(true);
        ColumnData idColumnData = new ColumnData(true, false, "id", this.table, this.tableIndex, this.idField);
        this.columns.add(idColumnData);
        Field versionField = this.superTableClass.getDeclaredField("version");
        versionField.setAccessible(true);
        ColumnData versionColumnData = new ColumnData(false, true, "version", this.table, this.tableIndex, versionField);
        this.columns.add(versionColumnData);
    }

    public String getColumnFromProperty(String property) throws NoSuchFieldException {
        return this.getColumnFromTable(this.tableClass, property);
    }

    private <E> Class<? super E> getTableFromEntity(Class<E> entityClass) throws TableParseException {
        Class<E> tableClass;
        Table tableAnnot;
        do {
            tableClass = entityClass.getSuperclass();
            tableAnnot = tableClass.getAnnotation(Table.class);
            if (!tableClass.equals(Object.class)) continue;
            throw new TableParseException("Error parsing Table Annotations");
        } while (tableAnnot == null);
        return tableClass;
    }

    public Field getIdField() {
        return this.idField;
    }

    public String getTable() {
        return this.table;
    }

    public String getTableIndex() {
        return this.tableIndex;
    }

    public Set<JoinData> getJoins() {
        return this.joins;
    }

    public Set<ColumnData> getColumns() {
        return this.columns;
    }

    public Map<Field, Class> getJoinEntities() {
        return this.joinEntities;
    }
}

