/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.AbstractTable;
import io.advant.orm.Entity;
import io.advant.orm.exception.TableParseException;
import io.advant.orm.internal.ColumnData;
import io.advant.orm.internal.EntityReflect;
import io.advant.orm.internal.ValueBridge;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class EntityConverter<T extends Entity> {
    private static final Logger LOGGER = Logger.getLogger(EntityConverter.class.getName());
    private final Class<T> entityClass;
    private final EntityReflect<T> entityReflect;

    public EntityConverter(Class<T> entityClass, EntityReflect<T> entityReflect) {
        this.entityClass = entityClass;
        this.entityReflect = entityReflect;
    }

    public T toEntity(ResultSet resultSet) throws SQLException, IllegalAccessException, InstantiationException, NoSuchFieldException, TableParseException {
        Entity entity = null;
        if (resultSet.next()) {
            entity = (Entity)this.entityClass.newInstance();
            this.setEntityColumns(resultSet, this.entityReflect.getColumns(), entity);
            this.setEntityJoins(resultSet, entity, this.entityReflect);
            while (resultSet.next()) {
                this.setEntityJoins(resultSet, entity, this.entityReflect);
            }
            ((AbstractTable)((Object)entity)).setLastId(entity.getId());
        }
        return (T)entity;
    }

    private <E extends Entity> E setEntityJoins(ResultSet resultSet, E currentEntity, EntityReflect<E> currentReflect) throws IllegalAccessException, InstantiationException, SQLException, NoSuchFieldException, TableParseException {
        if (currentReflect.getJoinEntities() != null) {
            for (Map.Entry<Field, Class> joinEntry : currentReflect.getJoinEntities().entrySet()) {
                Entity joinEntity;
                Field field = joinEntry.getKey();
                field.setAccessible(true);
                Class joinClass = joinEntry.getValue();
                EntityReflect joinReflect = EntityReflect.getInstance(joinClass);
                if (field.getType().equals(List.class)) {
                    ArrayList<Entity> list = (ArrayList<Entity>)field.get(currentEntity);
                    if (list == null) {
                        list = new ArrayList<Entity>();
                        field.set(currentEntity, list);
                    }
                    joinEntity = (Entity)joinClass.newInstance();
                    joinEntity.setId(this.getIdValue(joinReflect, resultSet));
                    int index = list.indexOf(joinEntity);
                    if (index == -1) {
                        this.setEntityColumns(resultSet, joinReflect.getColumns(), joinEntity);
                        list.add(joinEntity);
                    } else {
                        joinEntity = (Entity)list.get(index);
                    }
                    this.setEntityJoins(resultSet, joinEntity, joinReflect);
                    continue;
                }
                if (field.getType().equals(Set.class)) {
                    HashSet<Entity> set = (HashSet<Entity>)field.get(currentEntity);
                    if (set == null) {
                        set = new HashSet<Entity>();
                        field.set(currentEntity, set);
                    }
                    joinEntity = null;
                    for (Entity e : set) {
                        if (!e.getId().equals(this.getIdValue(joinReflect, resultSet))) continue;
                        joinEntity = e;
                        break;
                    }
                    if (joinEntity == null) {
                        joinEntity = (Entity)joinClass.newInstance();
                        this.setEntityColumns(resultSet, joinReflect.getColumns(), joinEntity);
                        set.add(joinEntity);
                    }
                    this.setEntityJoins(resultSet, joinEntity, joinReflect);
                    continue;
                }
                Entity joinEntity2 = (Entity)field.get(currentEntity);
                if (joinEntity2 == null) {
                    joinEntity2 = (Entity)joinClass.newInstance();
                    this.setEntityColumns(resultSet, joinReflect.getColumns(), joinEntity2);
                }
                this.setEntityJoins(resultSet, joinEntity2, joinReflect);
                field.set(currentEntity, joinEntity2);
            }
        }
        return currentEntity;
    }

    private <E> void setEntityColumns(ResultSet resultSet, Set<ColumnData> columns, E currentEntity) throws SQLException, IllegalAccessException {
        for (ColumnData columnData : columns) {
            Field field = columnData.getField();
            field.setAccessible(true);
            String columnName = EntityConverter.getColumnName(columnData.getTableIndex(), columnData.getColumn());
            ValueBridge.setField(currentEntity, field, columnData.getValueType(), columnName, resultSet);
        }
    }

    public List<T> toEntities(ResultSet resultSet) throws SQLException, IllegalAccessException, InstantiationException, NoSuchFieldException, TableParseException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        while (resultSet.next()) {
            Entity entity;
            Entity tmpEntity = (Entity)this.entityClass.newInstance();
            Long currentId = this.getIdValue(this.entityReflect, resultSet);
            tmpEntity.setId(currentId);
            int index = list.indexOf(tmpEntity);
            if (index == -1) {
                entity = (Entity)this.entityClass.newInstance();
                this.setEntityColumns(resultSet, this.entityReflect.getColumns(), entity);
                this.setEntityJoins(resultSet, entity, this.entityReflect);
                list.add(entity);
                continue;
            }
            entity = (Entity)list.get(index);
            this.setEntityJoins(resultSet, entity, this.entityReflect);
        }
        return list;
    }

    public List<ColumnData> fromEntity(T entity) throws IllegalAccessException {
        ArrayList<ColumnData> list = new ArrayList<ColumnData>();
        if (entity != null) {
            for (ColumnData columnData : this.entityReflect.getColumns()) {
                Field field = columnData.getField();
                Object value = field.get(entity);
                columnData.setValue(value);
                list.add(columnData);
            }
        }
        return list;
    }

    public static String getColumnName(String tableIndex, String column) {
        return tableIndex + "_" + column;
    }

    public Long getIdValue(EntityReflect reflect, ResultSet resultSet) throws SQLException {
        Field idField = reflect.getIdField();
        String idColumn = EntityConverter.getColumnName(reflect.getTableIndex(), idField.getName());
        return resultSet.getLong(idColumn);
    }
}

