/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.DB;
import io.advant.orm.DBConfig;
import io.advant.orm.DBConnection;
import io.advant.orm.exception.ConnectionException;
import io.advant.orm.exception.TableParseException;
import io.advant.orm.internal.DBConnectionParams;
import io.advant.orm.internal.EntityReflect;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DBImpl
implements DB {
    private static final Logger LOGGER = Logger.getLogger(DBImpl.class.getName());
    private final DBConfig config;
    private DataSource datasource;
    private DBConnection connection;

    public DBImpl(DBConfig config) {
        this.config = config;
        try {
            Class.forName(config.getDriver());
            for (String entity : config.getEntities()) {
                Class<?> entityClass = Class.forName(entity);
                EntityReflect.getInstance(entityClass);
            }
        }
        catch (TableParseException | ClassNotFoundException | NoSuchFieldException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public DataSource getDataSource() {
        if (this.datasource == null) {
            try {
                this.datasource = (DataSource)new InitialContext().lookup(this.config.getDatasource());
            }
            catch (NamingException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.datasource;
    }

    @Override
    public void connect() throws SQLException {
        Connection conn;
        if (this.config.getDatasource() != null) {
            conn = this.getDataSource().getConnection();
        } else {
            DBConnectionParams params = this.config.getParams();
            conn = DriverManager.getConnection(params.getUri(), params.getProperties());
        }
        this.connection = new DBConnection(conn, this.config.getDbType());
    }

    @Override
    public DBConnection getConnection() throws ConnectionException {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            throw new ConnectionException(e);
        }
        return this.connection;
    }

    @Override
    public boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

