/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.internal.Condition;
import io.advant.orm.internal.ConditionPool;
import java.util.ArrayList;
import java.util.List;

public class Conditions {
    private List<ConditionPool> pools = new ArrayList<ConditionPool>();
    private List<Condition> list = new ArrayList<Condition>();

    public Conditions(Condition condition) {
        this.pools.add(new ConditionPool(condition));
        this.list.add(condition);
    }

    public Conditions(ConditionPool pool) {
        this.pools.add(pool);
        this.list.addAll(pool.getConditions());
    }

    public Conditions and(Condition condition) {
        ConditionPool pool = new ConditionPool(condition);
        this.pools.add(pool);
        this.list.add(condition);
        return this;
    }

    public Conditions or(Condition condition) {
        ConditionPool pool = new ConditionPool(condition);
        this.pools.add(pool);
        this.list.add(condition);
        return this;
    }

    public Conditions and(ConditionPool pool) {
        this.pools.add(pool);
        this.list.addAll(pool.getConditions());
        return this;
    }

    public Conditions or(ConditionPool pool) {
        this.pools.add(pool);
        this.list.addAll(pool.getConditions());
        return this;
    }

    public List<ConditionPool> getPools() {
        return this.pools;
    }

    public List<Condition> getList() {
        return this.list;
    }

    private void recursivePool(StringBuilder sb, boolean isFirst, ConditionPool pool) {
        if (pool.getPool() != null) {
            this.recursivePool(sb, true, pool.getPool());
        } else if (isFirst) {
            this.iterateConditions(sb, pool.getConditions());
        } else {
            sb.append((Object)pool.getLogic()).append(" (");
            this.iterateConditions(sb, pool.getConditions());
            sb.append(") ");
        }
    }

    private void iterateConditions(StringBuilder sb, List<Condition> conditions) {
        boolean isFirst = true;
        for (Condition condition : conditions) {
            if (isFirst) {
                sb.append(condition);
            } else {
                sb.append((Object)condition.getLogic()).append(" ").append(condition).append(" ");
            }
            isFirst = false;
        }
    }

    public String asSQL() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (ConditionPool pool : this.pools) {
            this.recursivePool(sb, isFirst, pool);
            isFirst = false;
        }
        return sb.toString();
    }
}

