/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.Entity;
import io.advant.orm.exception.TableParseException;
import io.advant.orm.internal.EntityReflect;
import io.advant.orm.type.LogicType;
import io.advant.orm.type.OperatorType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Condition {
    private static final Logger LOGGER = Logger.getLogger(Condition.class.getName());
    private String table;
    private String column;
    private Object value;
    private OperatorType op;
    private LogicType logic;

    public Condition(Class<? extends Entity> entityClass, String column, Object value) {
        this(entityClass, column, OperatorType.eq, value);
    }

    public Condition(Class<? extends Entity> entityClass, String column, OperatorType op, Object value) {
        this.value = value;
        this.op = op;
        try {
            EntityReflect<? extends Entity> reflect = EntityReflect.getInstance(entityClass);
            this.table = reflect.getTable();
            this.column = reflect.getColumnFromProperty(column);
        }
        catch (TableParseException | NoSuchFieldException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setLogic(LogicType logic) {
        this.logic = logic;
    }

    public String getColumn() {
        return this.column;
    }

    public Object getValue() {
        return this.value;
    }

    public OperatorType getOp() {
        return this.op;
    }

    public LogicType getLogic() {
        return this.logic;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.table).append(".").append(this.column).append((Object)this.op).append("?");
        return sb.toString();
    }
}

