/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm.internal;

import io.advant.orm.type.ValueType;
import java.lang.reflect.Field;

public class ColumnData {
    private final boolean id;
    private final boolean version;
    private final String column;
    private final Field field;
    private final String table;
    private final String tableIndex;
    private final Class<?> type;
    private ValueType valueType;
    private Object value;

    public ColumnData(boolean id, boolean version, String column, String table, String tableIndex, Field field) {
        this.id = id;
        this.version = version;
        this.column = column;
        this.table = table;
        this.tableIndex = tableIndex;
        this.field = field;
        this.type = field.getType();
        for (ValueType valueType : ValueType.values()) {
            if (valueType.getType() != this.type) continue;
            this.valueType = valueType;
        }
    }

    public boolean isId() {
        return this.id;
    }

    public boolean isVersion() {
        return this.version;
    }

    public String getColumn() {
        return this.column;
    }

    public String getTable() {
        return this.table;
    }

    public String getTableIndex() {
        return this.tableIndex;
    }

    public Field getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

