/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm;

import io.advant.orm.DBConnection;
import io.advant.orm.DBFactory;
import io.advant.orm.DBMultiFactory;
import io.advant.orm.exception.ConnectionException;
import io.advant.orm.exception.OrmException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transaction {
    private static final Logger LOGGER = Logger.getLogger(Transaction.class.getName());
    private DBConnection connection;

    public Transaction() {
        try {
            this.connection = DBFactory.getInstance().getConnection();
        }
        catch (ConnectionException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Transaction(DBConnection connection) {
        this.connection = connection;
    }

    public Transaction(String connectionId) {
        try {
            this.connection = DBMultiFactory.getInstance(connectionId).getConnection();
        }
        catch (ConnectionException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static boolean isAutoCommit(DBConnection connection) throws OrmException {
        return new Transaction(connection).isAutoCommit();
    }

    public static boolean isAutoCommit(String connectionId) throws OrmException {
        return new Transaction(connectionId).isAutoCommit();
    }

    public boolean isAutoCommit() throws OrmException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
    }

    public static void setAutoCommit(DBConnection connection, boolean autoCommit) throws OrmException {
        new Transaction(connection).setAutoCommit(autoCommit);
    }

    public static void setAutoCommit(String connectionId, boolean autoCommit) throws OrmException {
        new Transaction(connectionId).setAutoCommit(autoCommit);
    }

    public void setAutoCommit(boolean autoCommit) throws OrmException {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
    }

    public static void commit(DBConnection connection) throws OrmException {
        new Transaction(connection).commit();
    }

    public static void commit(String connectionId) throws OrmException {
        new Transaction(connectionId).commit();
    }

    public void commit() throws OrmException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
    }

    public static void rollback(DBConnection connection) throws OrmException {
        new Transaction(connection).rollback();
    }

    public static void rollback(String connectionId) throws OrmException {
        new Transaction(connectionId).rollback();
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

