/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm;

import io.advant.orm.DB;
import io.advant.orm.DBConfig;
import io.advant.orm.internal.DBImpl;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class DBFactory {
    private static final Logger LOGGER = Logger.getLogger(DBFactory.class.getName());
    private static DB instance;

    private DBFactory() {
    }

    public static DB newInstance(DBConfig config) {
        instance = new DBImpl(config);
        return instance;
    }

    public static DB newInstance(Properties properties) {
        return DBFactory.newInstance(new DBConfig(properties));
    }

    public static DB newInstance(InputStream stream) {
        return DBFactory.newInstance(new DBConfig(stream));
    }

    public static DB newInstance() {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("advantorm.properties");
        return DBFactory.newInstance(stream);
    }

    public static DB getInstance() {
        if (instance == null) {
            DBFactory.newInstance();
        }
        return instance;
    }
}

