/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm;

import io.advant.orm.internal.DBConnectionParams;
import io.advant.orm.type.DBType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBConfig {
    private static final Logger LOGGER = Logger.getLogger(DBConfig.class.getName());
    private String datasource;
    private DBType dbType;
    private String driver;
    private String host;
    private int port;
    private String database;
    private String user;
    private String password;
    private Properties properties;
    private Set<String> entities = new HashSet<String>();

    public DBConfig(Properties configProps) {
        this.configureProperties(configProps);
    }

    public DBConfig(InputStream inputStream) {
        try {
            Properties configProps = new Properties();
            configProps.load(inputStream);
            this.configureProperties(configProps);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void configureProperties(Properties configProps) {
        this.datasource = configProps.getProperty("datasource");
        this.dbType = DBType.valueOf(configProps.getProperty("db.type").toUpperCase());
        this.driver = this.dbType.getDriver();
        this.host = configProps.getProperty("db.host");
        this.port = Integer.valueOf(configProps.getProperty("db.port", "0"));
        this.database = configProps.getProperty("db.database");
        this.user = configProps.getProperty("db.user");
        this.password = configProps.getProperty("db.password");
        Enumeration<Object> enumKey = configProps.keys();
        while (enumKey.hasMoreElements()) {
            String value;
            String dbProperty;
            String key = (String)enumKey.nextElement();
            if (key.startsWith(dbProperty = "db.property.")) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                value = configProps.getProperty(key);
                this.properties.put(key.substring(dbProperty.length()), value);
                continue;
            }
            if (!key.startsWith("entity.")) continue;
            if (this.entities == null) {
                this.entities = new HashSet<String>();
            }
            value = configProps.getProperty(key);
            this.entities.add(value);
        }
    }

    public DBConfig(String datasource) {
        this.datasource = datasource;
    }

    public DBConfig(DBType dbType, String host, int port, String database, String user, String password) {
        this(dbType, database, user, password);
        this.host = host;
        this.port = port;
    }

    public DBConfig(DBType dbType, String database, String user, String password) {
        this.driver = dbType.getDriver();
        this.dbType = dbType;
        this.database = database;
        this.user = user;
        this.password = password;
    }

    public DBConnectionParams getParams() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.user != null) {
            this.properties.put("user", this.user);
        }
        if (this.password != null) {
            this.properties.put("password", this.password);
        }
        return new DBConnectionParams(){

            @Override
            public String getUri() {
                return DBConfig.this.getDBTypeUri();
            }

            @Override
            public Properties getProperties() {
                return DBConfig.this.properties;
            }
        };
    }

    private String getDBTypeUri() {
        switch (this.dbType) {
            case MYSQL: {
                return "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database;
            }
            case POSTGRESQL: {
                return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.database;
            }
            case IBMDB2: {
                return "jdbc:db2://" + this.host + ":" + this.port + "/" + this.database;
            }
            case MSSQL: {
                return "jdbc:microsoft:sqlserver://" + this.host + ":" + this.port + "/" + this.database;
            }
            case SYBASE: {
                return "jdbc:jtds:sybase://" + this.host + ":" + this.port + "/" + this.database;
            }
            case ORACLE: {
                return "jdbc:oracle:thin:@" + this.host + ":" + this.port + ":" + this.database;
            }
            case DERBY: {
                return "jdbc:derby:" + this.database;
            }
            case H2: {
                return "jdbc:h2:" + this.database;
            }
            case HSQLDB: {
                return "jdbc:hsqldb:" + this.database;
            }
            case SQLITE: {
                return "jdbc:sqlite:" + this.database;
            }
        }
        LOGGER.log(Level.SEVERE, "DBType not known or isn't a Local connection");
        return null;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }
}

