/*
 * Decompiled with CFR 0.152.
 */
package io.advant.orm;

import io.advant.orm.DAO;
import io.advant.orm.DBConnection;
import io.advant.orm.Entity;
import io.advant.orm.exception.OrmException;
import io.advant.orm.exception.TableParseException;
import io.advant.orm.exception.UnsynchronizedException;
import io.advant.orm.internal.ColumnData;
import io.advant.orm.internal.Condition;
import io.advant.orm.internal.Conditions;
import io.advant.orm.internal.EntityConverter;
import io.advant.orm.internal.EntityReflect;
import io.advant.orm.internal.SqlProcessor;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDAO<T extends Entity>
implements DAO<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractDAO.class.getName());
    private final DBConnection connection;
    private final Class<T> entityClass;
    private SqlProcessor sqlProcessor;
    private EntityConverter<T> converter;

    protected AbstractDAO(DBConnection connection) {
        this.connection = connection;
        this.entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.loadEntities();
    }

    AbstractDAO(Class<T> entityClass, DBConnection connection) {
        this.connection = connection;
        this.entityClass = entityClass;
        this.loadEntities();
    }

    private void loadEntities() {
        try {
            EntityReflect<T> reflect = EntityReflect.getInstance(this.entityClass);
            this.converter = new EntityConverter<T>(this.entityClass, reflect);
            this.sqlProcessor = new SqlProcessor(this.connection, reflect);
        }
        catch (TableParseException | NoSuchFieldException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void close() {
        try {
            this.sqlProcessor.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public int deleteAll() throws OrmException {
        try {
            int n = this.sqlProcessor.deleteAll();
            return n;
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void insert(T entity) throws OrmException {
        try {
            this.sqlProcessor.insert(entity, this.fromEntity(entity));
        }
        catch (IllegalAccessException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public int update(T entity) throws OrmException {
        try {
            int n = this.sqlProcessor.update(entity, this.fromEntity(entity));
            return n;
        }
        catch (UnsynchronizedException | IllegalAccessException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public Integer save(T entity) throws OrmException {
        try {
            Integer result = null;
            Conditions conditions = new Conditions(new Condition(this.entityClass, "id", entity.getId()));
            ResultSet resultSet = this.sqlProcessor.select(conditions);
            String tableIndex = EntityReflect.getInstance(this.entityClass).getTableIndex();
            String columnNameId = EntityConverter.getColumnName(tableIndex, "id");
            String columnNameVersion = EntityConverter.getColumnName(tableIndex, "version");
            Long id = null;
            Long version = null;
            if (resultSet.next()) {
                id = resultSet.getLong(columnNameId);
                version = resultSet.getLong(columnNameVersion);
            }
            entity.setId(id);
            entity.setVersion(version);
            List<ColumnData> columns = this.fromEntity(entity);
            if (id == null) {
                this.sqlProcessor.insert(entity, columns);
            } else {
                result = this.sqlProcessor.update(entity, columns);
            }
            Integer n = result;
            return n;
        }
        catch (TableParseException | UnsynchronizedException | IllegalAccessException | NoSuchFieldException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public int delete(T entity) throws OrmException {
        try {
            int n = this.sqlProcessor.delete(entity);
            return n;
        }
        catch (UnsynchronizedException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public int delete(Conditions conditions) throws OrmException {
        try {
            int n = this.sqlProcessor.delete(conditions);
            return n;
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public List<T> findAll() throws OrmException {
        try {
            ResultSet rs = this.sqlProcessor.select(null);
            List<T> list = this.toEntities(rs);
            return list;
        }
        catch (TableParseException | NoSuchFieldException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public T find(Long id) throws OrmException {
        try {
            Conditions conditions = new Conditions(new Condition(this.entityClass, "id", id));
            ResultSet rs = this.sqlProcessor.select(conditions);
            T t = this.toEntity(rs);
            return t;
        }
        catch (TableParseException | NoSuchFieldException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public List<T> find(Conditions conditions) throws OrmException {
        try {
            ResultSet rs = this.sqlProcessor.select(conditions);
            List<T> list = this.toEntities(rs);
            return list;
        }
        catch (TableParseException | NoSuchFieldException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
        finally {
            this.close();
        }
    }

    protected T toEntity(ResultSet rs) throws OrmException {
        try {
            return this.converter.toEntity(rs);
        }
        catch (TableParseException | IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
    }

    protected List<T> toEntities(ResultSet rs) throws OrmException {
        try {
            return this.converter.toEntities(rs);
        }
        catch (TableParseException | IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
    }

    protected List<ColumnData> fromEntity(T entity) throws OrmException {
        try {
            return this.converter.fromEntity(entity);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new OrmException(e);
        }
    }
}

