/*
 * Decompiled with CFR 0.152.
 */
package io.activej.uikernel;

import com.google.gson.Gson;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.exception.parse.ParseException;
import io.activej.http.AsyncServlet;
import io.activej.http.AsyncServletDecorator;
import io.activej.http.ContentType;
import io.activej.http.HttpException;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMethod;
import io.activej.http.HttpResponse;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;
import io.activej.http.RoutingServlet;
import io.activej.promise.Promise;
import io.activej.uikernel.AbstractRecord;
import io.activej.uikernel.GridModel;
import io.activej.uikernel.ReadSettings;
import io.activej.uikernel.Utils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class UiKernelServlets {
    private static final ContentType JSON_UTF8 = ContentType.of((MediaType)MediaTypes.JSON, (Charset)StandardCharsets.UTF_8);
    private static final String ID_PARAMETER_NAME = "id";

    public static <K, R extends AbstractRecord<K>> RoutingServlet apiServlet(GridModel<K, R> model, Gson gson) {
        return RoutingServlet.create().map(HttpMethod.POST, "/", UiKernelServlets.create(model, gson)).map(HttpMethod.GET, "/", UiKernelServlets.read(model, gson)).map(HttpMethod.PUT, "/", UiKernelServlets.update(model, gson)).map(HttpMethod.DELETE, "/:id", UiKernelServlets.delete(model, gson)).map(HttpMethod.GET, "/:id", UiKernelServlets.get(model, gson));
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet read(GridModel<K, R> model, Gson gson) {
        return request -> {
            try {
                ReadSettings settings = ReadSettings.from(gson, request);
                return model.read(settings).map(response -> UiKernelServlets.createResponse(response.toJson(gson, model.getRecordType(), model.getIdType())));
            }
            catch (ParseException e) {
                return Promise.ofException((Throwable)HttpException.ofCode((int)400, (Throwable)e));
            }
        };
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet get(GridModel<K, R> model, Gson gson) {
        return request -> {
            try {
                ReadSettings settings = ReadSettings.from(gson, request);
                Object id = Utils.fromJson(gson, request.getPathParameter(ID_PARAMETER_NAME), model.getIdType());
                return model.read(id, settings).map(obj -> UiKernelServlets.createResponse(gson.toJson(obj, model.getRecordType())));
            }
            catch (ParseException e) {
                return Promise.ofException((Throwable)HttpException.ofCode((int)400, (Throwable)e));
            }
        };
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet create(GridModel<K, R> model, Gson gson) {
        return AsyncServletDecorator.loadBody().serve(request -> {
            try {
                String json = request.getBody().getString(StandardCharsets.UTF_8);
                AbstractRecord obj = (AbstractRecord)Utils.fromJson(gson, json, model.getRecordType());
                return model.create(obj).map(response -> UiKernelServlets.createResponse(response.toJson(gson, model.getIdType())));
            }
            catch (ParseException e) {
                return Promise.ofException((Throwable)HttpException.ofCode((int)400, (Throwable)e));
            }
        });
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet update(GridModel<K, R> model, Gson gson) {
        return AsyncServletDecorator.loadBody().serve(request -> {
            try {
                String json = request.getBody().getString(StandardCharsets.UTF_8);
                List list = Utils.deserializeUpdateRequest(gson, json, model.getRecordType(), model.getIdType());
                return model.update(list).map(result -> UiKernelServlets.createResponse(result.toJson(gson, model.getRecordType(), model.getIdType())));
            }
            catch (ParseException e) {
                return Promise.ofException((Throwable)HttpException.ofCode((int)400, (Throwable)e));
            }
        });
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet delete(GridModel<K, R> model, Gson gson) {
        return request -> {
            try {
                Object id = Utils.fromJson(gson, request.getPathParameter(ID_PARAMETER_NAME), model.getIdType());
                return model.delete(id).map(response -> {
                    HttpResponse res = HttpResponse.ok200();
                    if (response.hasErrors()) {
                        String json = gson.toJson(response.getErrors());
                        res.addHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType((ContentType)JSON_UTF8));
                        res.setBody(ByteBufStrings.wrapUtf8((String)json));
                    }
                    return res;
                });
            }
            catch (ParseException e) {
                return Promise.ofException((Throwable)HttpException.ofCode((int)400, (Throwable)e));
            }
        };
    }

    private static HttpResponse createResponse(String body) {
        return HttpResponse.ok200().withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType((ContentType)JSON_UTF8)).withBody(ByteBufStrings.wrapUtf8((String)body));
    }
}

