/*
 * Decompiled with CFR 0.152.
 */
package io.activej.uikernel;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.activej.uikernel.AbstractRecord;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReadResponse<K, R extends AbstractRecord<K>> {
    private final List<R> records;
    private final int count;
    private final List<R> extra;
    @Nullable
    private final R totals;

    private ReadResponse(@NotNull List<R> records, int count, @NotNull List<R> extra, @Nullable R totals) {
        this.records = records;
        this.count = count;
        this.extra = extra;
        this.totals = totals;
    }

    public static <K, R extends AbstractRecord<K>> ReadResponse<K, R> of(List<R> records, int count) {
        return new ReadResponse<K, Object>(records, count, Collections.emptyList(), null);
    }

    public static <K, R extends AbstractRecord<K>> ReadResponse<K, R> of(List<R> records, int count, List<R> extra) {
        return new ReadResponse<K, Object>(records, count, extra, null);
    }

    public static <K, R extends AbstractRecord<K>> ReadResponse<K, R> of(List<R> records, int count, List<R> extra, R totals) {
        return new ReadResponse<K, R>(records, count, extra, totals);
    }

    String toJson(Gson gson, Class<R> type, Class<K> idType) {
        JsonObject result = new JsonObject();
        JsonArray recs = new JsonArray();
        for (AbstractRecord record : this.records) {
            JsonArray arr = new JsonArray();
            arr.add(gson.toJsonTree(record.getId(), idType));
            arr.add(gson.toJsonTree((Object)record, type));
            recs.add((JsonElement)arr);
        }
        result.add("records", (JsonElement)recs);
        JsonArray extras = new JsonArray();
        for (AbstractRecord record : this.extra) {
            JsonArray arr = new JsonArray();
            arr.add(gson.toJsonTree(record.getId(), idType));
            arr.add(gson.toJsonTree((Object)record, type));
            extras.add((JsonElement)arr);
        }
        result.add("extra", (JsonElement)extras);
        if (this.totals != null) {
            result.add("total", gson.toJsonTree(this.totals, type));
        }
        result.add("count", gson.toJsonTree((Object)this.count));
        return gson.toJson((JsonElement)result);
    }
}

