/*
 * Decompiled with CFR 0.152.
 */
package io.activej.uikernel;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CreateResponse<K> {
    private final K id;
    private final Map<String, List<String>> errors;

    private CreateResponse(@NotNull K id, @NotNull Map<String, List<String>> errors) {
        this.id = id;
        this.errors = errors;
    }

    public static <K> CreateResponse<K> of(K id) {
        return new CreateResponse<K>(id, Collections.emptyMap());
    }

    public static <K> CreateResponse<K> of(K id, Map<String, List<String>> errors) {
        return new CreateResponse<K>(id, errors);
    }

    String toJson(Gson gson, Class<K> idType) {
        JsonObject result = new JsonObject();
        result.add("data", gson.toJsonTree(this.id, idType));
        result.add("errors", gson.toJsonTree(this.errors));
        return gson.toJson((JsonElement)result);
    }
}

