/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.datastream.processor.StreamFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;

public final class NodeFilter<T>
extends AbstractNode {
    private final Predicate<T> predicate;
    private final StreamId input;
    private final StreamId output;

    public NodeFilter(int index, Predicate<T> predicate, StreamId input) {
        this(index, predicate, input, new StreamId());
    }

    public NodeFilter(int index, Predicate<T> predicate, StreamId input, StreamId output) {
        super(index);
        this.predicate = predicate;
        this.input = input;
        this.output = output;
    }

    @Override
    public Collection<StreamId> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        StreamFilter streamFilter = StreamFilter.create(this.predicate);
        task.bindChannel(this.input, streamFilter.getInput());
        task.export(this.output, streamFilter.getOutput());
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public StreamId getInput() {
        return this.input;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public String toString() {
        return "NodeFilter{predicate=" + this.predicate.getClass().getSimpleName() + ", input=" + this.input + ", output=" + this.output + '}';
    }
}

