/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.graph;

import io.activej.common.ref.RefInt;
import io.activej.dataflow.graph.DataflowGraph;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Nullable;

public final class DataflowContext {
    private final DataflowGraph graph;
    private final RefInt nextNodeIndex;
    @Nullable
    private final Integer nonce;

    private DataflowContext(DataflowGraph graph, @Nullable Integer nonce, RefInt nextNodeIndex) {
        this.nonce = nonce;
        this.graph = graph;
        this.nextNodeIndex = nextNodeIndex;
    }

    public static DataflowContext of(DataflowGraph graph) {
        return new DataflowContext(graph, null, new RefInt(0));
    }

    public int generateNodeIndex() {
        return this.nextNodeIndex.value++;
    }

    public DataflowGraph getGraph() {
        return this.graph;
    }

    public int getNonce() {
        return this.nonce == null ? ThreadLocalRandom.current().nextInt() : this.nonce.intValue();
    }

    public DataflowContext withFixedNonce(int nonce) {
        return new DataflowContext(this.graph, nonce, this.nextNodeIndex);
    }

    public DataflowContext withoutFixedNonce() {
        return new DataflowContext(this.graph, null, this.nextNodeIndex);
    }
}

