/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.DataflowGraph;
import io.activej.dataflow.graph.Partition;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.node.NodeSupplierOfId;
import java.util.ArrayList;
import java.util.List;

public final class DatasetSupplierOfId<T>
extends Dataset<T> {
    private final String id;

    public DatasetSupplierOfId(String id, Class<T> resultType) {
        super(resultType);
        this.id = id;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        DataflowGraph graph = context.getGraph();
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<Partition> availablePartitions = graph.getAvailablePartitions();
        int index = context.generateNodeIndex();
        int size = availablePartitions.size();
        for (int i = 0; i < size; ++i) {
            Partition partition = availablePartitions.get(i);
            NodeSupplierOfId node = new NodeSupplierOfId(index, this.id, i, size);
            graph.addNode(partition, node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }
}

