/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.dataset.DatasetUtils;
import io.activej.dataflow.dataset.LocallySortedDataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.Partition;
import io.activej.dataflow.graph.StreamId;
import io.activej.datastream.processor.StreamReducers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DatasetRepartitionReduce<K, I, O>
extends Dataset<O> {
    private final LocallySortedDataset<K, I> input;
    private final StreamReducers.Reducer<K, I, O, ?> reducer;
    private final List<Partition> partitions;

    public DatasetRepartitionReduce(LocallySortedDataset<K, I> input, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType) {
        this(input, reducer, resultType, null);
    }

    public DatasetRepartitionReduce(LocallySortedDataset<K, I> input, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, List<Partition> partitions) {
        super(resultType);
        this.input = input;
        this.reducer = reducer;
        this.partitions = partitions;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        List<Partition> ps = this.partitions != null && !this.partitions.isEmpty() ? this.partitions : context.getGraph().getAvailablePartitions();
        return DatasetUtils.repartitionAndReduce(context, this.input, this.reducer, ps);
    }

    @Override
    public Collection<Dataset<?>> getBases() {
        return Collections.singletonList(this.input);
    }
}

