/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.dataset.LocallySortedDataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.DataflowGraph;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.node.NodeReduceSimple;
import io.activej.datastream.processor.StreamReducers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class DatasetLocalSortReduce<K, I, O>
extends LocallySortedDataset<K, O> {
    private final LocallySortedDataset<K, I> input;
    private final StreamReducers.Reducer<K, I, O, ?> reducer;

    public DatasetLocalSortReduce(LocallySortedDataset<K, I> input, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, Function<O, K> resultKeyFunction) {
        super(resultType, input.keyComparator(), input.keyType(), resultKeyFunction);
        this.input = input;
        this.reducer = reducer;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        DataflowGraph graph = context.getGraph();
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        int index = context.generateNodeIndex();
        for (StreamId streamId : this.input.channels(context)) {
            NodeReduceSimple node = new NodeReduceSimple(index, this.input.keyFunction(), this.input.keyComparator(), this.reducer);
            node.addInput(streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }

    @Override
    public Collection<Dataset<?>> getBases() {
        return Collections.singletonList(this.input);
    }
}

