/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.DataflowGraph;
import io.activej.dataflow.graph.Partition;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.node.NodeConsumerOfId;
import java.util.Collections;
import java.util.List;

public final class DatasetConsumerOfId<T>
extends Dataset<T> {
    private final String id;
    private final Dataset<T> input;

    public DatasetConsumerOfId(Dataset<T> input, String id) {
        super(input.valueType());
        this.id = id;
        this.input = input;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        DataflowGraph graph = context.getGraph();
        List<StreamId> streamIds = this.input.channels(context);
        int index = context.generateNodeIndex();
        int streamIdsSize = streamIds.size();
        for (int i = 0; i < streamIdsSize; ++i) {
            StreamId streamId = streamIds.get(i);
            Partition partition = graph.getPartition(streamId);
            NodeConsumerOfId node = new NodeConsumerOfId(index, this.id, i, streamIdsSize, streamId);
            graph.addNode(partition, node);
        }
        return Collections.emptyList();
    }
}

