/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.util;

import io.activej.codegen.Context;
import io.activej.codegen.util.Primitives;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class Utils {
    private static final Map<String, Type> WRAPPER_TO_PRIMITIVE = new HashMap<String, Type>();
    private static final Type WRAPPED_BOOLEAN_TYPE;
    private static final Type WRAPPED_CHAR_TYPE;
    private static final Type WRAPPED_BYTE_TYPE;
    private static final Type WRAPPED_SHORT_TYPE;
    private static final Type WRAPPED_INT_TYPE;
    private static final Type WRAPPED_FLOAT_TYPE;
    private static final Type WRAPPED_LONG_TYPE;
    private static final Type WRAPPED_DOUBLE_TYPE;
    private static final Type WRAPPED_VOID_TYPE;

    public static boolean isPrimitiveType(Type type) {
        int sort = type.getSort();
        return sort == 1 || sort == 2 || sort == 3 || sort == 4 || sort == 5 || sort == 6 || sort == 7 || sort == 8 || sort == 0;
    }

    public static boolean isWrapperType(Type type) {
        return type.getSort() == 10 && WRAPPER_TO_PRIMITIVE.containsKey(type.getClassName());
    }

    public static Method toPrimitive(Type type) {
        if (type.getSort() == 1 || type.equals((Object)WRAPPED_BOOLEAN_TYPE)) {
            return Method.getMethod((String)"boolean booleanValue()");
        }
        if (type.getSort() == 2 || type.equals((Object)WRAPPED_CHAR_TYPE)) {
            return Method.getMethod((String)"char charValue()");
        }
        if (type.getSort() == 3 || type.equals((Object)WRAPPED_BYTE_TYPE)) {
            return Method.getMethod((String)"byte byteValue()");
        }
        if (type.getSort() == 4 || type.equals((Object)WRAPPED_SHORT_TYPE)) {
            return Method.getMethod((String)"short shortValue()");
        }
        if (type.getSort() == 5 || type.equals((Object)WRAPPED_INT_TYPE)) {
            return Method.getMethod((String)"int intValue()");
        }
        if (type.getSort() == 6 || type.equals((Object)WRAPPED_FLOAT_TYPE)) {
            return Method.getMethod((String)"float floatValue()");
        }
        if (type.getSort() == 7 || type.equals((Object)WRAPPED_LONG_TYPE)) {
            return Method.getMethod((String)"long longValue()");
        }
        if (type.getSort() == 8 || type.equals((Object)WRAPPED_DOUBLE_TYPE)) {
            return Method.getMethod((String)"double doubleValue()");
        }
        throw new IllegalArgumentException(String.format("No primitive value method for %s ", type.getClassName()));
    }

    public static Type wrap(Type type) {
        int sort = type.getSort();
        if (sort == 1) {
            return WRAPPED_BOOLEAN_TYPE;
        }
        if (sort == 2) {
            return WRAPPED_CHAR_TYPE;
        }
        if (sort == 3) {
            return WRAPPED_BYTE_TYPE;
        }
        if (sort == 4) {
            return WRAPPED_SHORT_TYPE;
        }
        if (sort == 5) {
            return WRAPPED_INT_TYPE;
        }
        if (sort == 6) {
            return WRAPPED_FLOAT_TYPE;
        }
        if (sort == 7) {
            return WRAPPED_LONG_TYPE;
        }
        if (sort == 8) {
            return WRAPPED_DOUBLE_TYPE;
        }
        if (sort == 0) {
            return WRAPPED_VOID_TYPE;
        }
        throw new IllegalArgumentException(String.format("%s is not primitive", type.getClassName()));
    }

    public static Type unwrap(@NotNull Type type) {
        if (type.getSort() != 10) {
            throw new IllegalArgumentException("Cannot unwrap type that is not an object reference");
        }
        @Nullable Type reference = WRAPPER_TO_PRIMITIVE.get(type.getClassName());
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static void invokeVirtualOrInterface(GeneratorAdapter g, Class<?> owner, Method method) {
        if (owner.isInterface()) {
            g.invokeInterface(Type.getType(owner), method);
        } else {
            g.invokeVirtual(Type.getType(owner), method);
        }
    }

    public static String exceptionInGeneratedClass(Context ctx) {
        return String.format("Thrown in generated class %s in method %s", ctx.getSelfType().getClassName(), ctx.getMethod());
    }

    public static boolean isValidCast(Type from, Type to) {
        return from.getSort() != to.getSort() && from.getSort() >= 1 && from.getSort() <= 8 && to.getSort() >= 1 && to.getSort() <= 8;
    }

    static {
        for (Class<?> primitiveType : Primitives.allPrimitiveTypes()) {
            Class<?> wrappedType = Primitives.wrap(primitiveType);
            WRAPPER_TO_PRIMITIVE.put(wrappedType.getName(), Type.getType(primitiveType));
        }
        WRAPPED_BOOLEAN_TYPE = Type.getType(Boolean.class);
        WRAPPED_CHAR_TYPE = Type.getType(Character.class);
        WRAPPED_BYTE_TYPE = Type.getType(Byte.class);
        WRAPPED_SHORT_TYPE = Type.getType(Short.class);
        WRAPPED_INT_TYPE = Type.getType(Integer.class);
        WRAPPED_FLOAT_TYPE = Type.getType(Float.class);
        WRAPPED_LONG_TYPE = Type.getType(Long.class);
        WRAPPED_DOUBLE_TYPE = Type.getType(Double.class);
        WRAPPED_VOID_TYPE = Type.getType(Void.class);
    }
}

