/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.util.Utils;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class ExpressionHash
implements Expression {
    private final List<Expression> arguments;

    ExpressionHash(List<Expression> arguments) {
        this.arguments = arguments;
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        int resultVar = g.newLocal(Type.INT_TYPE);
        boolean firstIteration = true;
        for (Expression argument : this.arguments) {
            if (firstIteration) {
                g.push(0);
                firstIteration = false;
            } else {
                g.push(31);
                g.loadLocal(resultVar);
                g.math(104, Type.INT_TYPE);
            }
            Type fieldType = argument.load(ctx);
            if (Utils.isPrimitiveType(fieldType)) {
                if (fieldType.getSort() == 7) {
                    g.dup2();
                    g.push(32);
                    g.visitInsn(125);
                    g.visitInsn(131);
                    g.visitInsn(136);
                }
                if (fieldType.getSort() == 6) {
                    g.invokeStatic(Type.getType(Float.class), Method.getMethod((String)"int floatToRawIntBits (float)"));
                }
                if (fieldType.getSort() == 8) {
                    g.invokeStatic(Type.getType(Double.class), Method.getMethod((String)"long doubleToRawLongBits (double)"));
                    g.dup2();
                    g.push(32);
                    g.visitInsn(125);
                    g.visitInsn(131);
                    g.visitInsn(136);
                }
                g.visitInsn(96);
            } else {
                int tmpVar = g.newLocal(fieldType);
                g.storeLocal(tmpVar);
                g.loadLocal(tmpVar);
                Label ifNullLabel = g.newLabel();
                g.ifNull(ifNullLabel);
                g.loadLocal(tmpVar);
                g.invokeVirtual(fieldType, Method.getMethod((String)"int hashCode()"));
                g.visitInsn(96);
                g.mark(ifNullLabel);
            }
            g.storeLocal(resultVar);
        }
        if (firstIteration) {
            g.push(0);
        } else {
            g.loadLocal(resultVar);
        }
        return Type.INT_TYPE;
    }
}

