/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.VarLocal;
import io.activej.codegen.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class ExpressionComparator
implements Expression {
    private final List<ComparablePair> pairs = new ArrayList<ComparablePair>();

    private ExpressionComparator() {
    }

    public static ExpressionComparator create() {
        return new ExpressionComparator();
    }

    public ExpressionComparator with(Expression left, Expression right) {
        return this.with(left, right, false);
    }

    public ExpressionComparator with(Expression left, Expression right, boolean nullable) {
        this.pairs.add(new ComparablePair(left, right, nullable));
        return this;
    }

    public static Expression thisProperty(String property) {
        return Expressions.property(Expressions.self(), property);
    }

    public static Expression thatProperty(String property) {
        return Expressions.property(Expressions.castIntoSelf(Expressions.arg(0)), property);
    }

    public static Expression leftProperty(Class<?> type, String property) {
        return Expressions.property(Expressions.cast(Expressions.arg(0), type), property);
    }

    public static Expression rightProperty(Class<?> type, String property) {
        return Expressions.property(Expressions.cast(Expressions.arg(1), type), property);
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Label labelReturn = new Label();
        for (ComparablePair pair : this.pairs) {
            Type rightPropertyType;
            Type leftPropertyType = pair.left.load(ctx);
            if (!leftPropertyType.equals((Object)(rightPropertyType = pair.right.load(ctx)))) {
                throw new IllegalArgumentException("Types of compared values should match");
            }
            if (Utils.isPrimitiveType(leftPropertyType)) {
                g.invokeStatic(Utils.wrap(leftPropertyType), new Method("compare", Type.INT_TYPE, new Type[]{leftPropertyType, leftPropertyType}));
                g.dup();
                g.ifZCmp(154, labelReturn);
                g.pop();
                continue;
            }
            if (!pair.nullable) {
                g.invokeVirtual(leftPropertyType, new Method("compareTo", Type.INT_TYPE, new Type[]{Type.getType(Object.class)}));
                g.dup();
                g.ifZCmp(154, labelReturn);
                g.pop();
                continue;
            }
            VarLocal varRight = ctx.newLocal(rightPropertyType);
            varRight.store(ctx);
            VarLocal varLeft = ctx.newLocal(leftPropertyType);
            varLeft.store(ctx);
            Label continueLabel = new Label();
            Label nonNulls = new Label();
            Label leftNonNull = new Label();
            varLeft.load(ctx);
            g.ifNonNull(leftNonNull);
            varRight.load(ctx);
            g.ifNull(continueLabel);
            g.push(-1);
            g.returnValue();
            g.mark(leftNonNull);
            varRight.load(ctx);
            g.ifNonNull(nonNulls);
            g.push(1);
            g.returnValue();
            g.mark(nonNulls);
            varLeft.load(ctx);
            varRight.load(ctx);
            g.invokeVirtual(leftPropertyType, new Method("compareTo", Type.INT_TYPE, new Type[]{Type.getType(Object.class)}));
            g.dup();
            g.ifZCmp(154, labelReturn);
            g.pop();
            g.mark(continueLabel);
        }
        g.push(0);
        g.mark(labelReturn);
        return Type.INT_TYPE;
    }

    private static final class ComparablePair {
        private final Expression left;
        private final Expression right;
        private final boolean nullable;

        private ComparablePair(Expression left, Expression right, boolean nullable) {
            this.left = left;
            this.right = right;
            this.nullable = nullable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparablePair that = (ComparablePair)o;
            if (this.nullable != that.nullable) {
                return false;
            }
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.right.equals(that.right);
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = 31 * result + this.right.hashCode();
            result = 31 * result + (this.nullable ? 1 : 0);
            return result;
        }
    }
}

