/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE;
    private static final Map<Class<?>, Class<?>> WRAPPER;

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static Set<Class<?>> allPrimitiveTypes() {
        return PRIMITIVE.keySet();
    }

    public static Set<Class<?>> allWrapperTypes() {
        return WRAPPER.keySet();
    }

    public static boolean isWrapperType(@NotNull Class<?> type) {
        return WRAPPER.containsKey(type);
    }

    public static <T> Class<T> wrap(@NotNull Class<T> type) {
        Class<?> wrapped = PRIMITIVE.get(type);
        return wrapped == null ? type : wrapped;
    }

    public static <T> Class<T> unwrap(@NotNull Class<T> type) {
        Class<?> unwrapped = WRAPPER.get(type);
        return unwrapped == null ? type : unwrapped;
    }

    static {
        HashMap primToWrap = new HashMap();
        HashMap wrapToPrim = new HashMap();
        Primitives.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        Primitives.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        Primitives.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        Primitives.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        Primitives.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        Primitives.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        Primitives.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        Primitives.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        Primitives.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE = Collections.unmodifiableMap(primToWrap);
        WRAPPER = Collections.unmodifiableMap(wrapToPrim);
    }
}

