/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ExpressionIf
implements Expression {
    private final Expression condition;
    private final Expression left;
    private final Expression right;

    ExpressionIf(@NotNull Expression condition, @NotNull Expression left, @NotNull Expression right) {
        this.condition = condition;
        this.left = left;
        this.right = right;
    }

    @Override
    public Type load(Context ctx) {
        Label labelTrue = new Label();
        Label labelExit = new Label();
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Type conditionType = this.condition.load(ctx);
        g.push(true);
        g.ifCmp(conditionType, 153, labelTrue);
        this.right.load(ctx);
        g.goTo(labelExit);
        g.mark(labelTrue);
        Type leftType = this.left.load(ctx);
        g.mark(labelExit);
        return leftType;
    }
}

