/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.VarLocal;
import java.util.Iterator;
import java.util.function.Function;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public abstract class AbstractExpressionIteratorForEach
implements Expression {
    protected final Expression collection;
    protected final Class<?> type;
    protected final Function<Expression, Expression> forEach;

    protected AbstractExpressionIteratorForEach(Expression collection, Class<?> type, Function<Expression, Expression> forEach) {
        this.collection = collection;
        this.type = type;
        this.forEach = forEach;
    }

    protected abstract Expression getValue(VarLocal var1);

    @Override
    public final Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Label labelLoop = new Label();
        Label labelExit = new Label();
        Type collectionType = this.collection.load(ctx);
        if (collectionType.getSort() == 9) {
            return this.arrayForEach(ctx, g, labelLoop, labelExit);
        }
        VarLocal varIter = ctx.newLocal(Type.getType(Iterator.class));
        Class<?> t = ctx.toJavaType(collectionType);
        if (!Iterator.class.isAssignableFrom(t)) {
            ctx.invoke(collectionType, "iterator", new Type[0]);
        }
        varIter.store(ctx);
        g.mark(labelLoop);
        ctx.invoke((Expression)varIter, "hasNext", new Expression[0]);
        g.push(false);
        g.ifCmp(Type.BOOLEAN_TYPE, 153, labelExit);
        ctx.cast(ctx.invoke((Expression)varIter, "next", new Expression[0]), Type.getType(this.type));
        VarLocal it = ctx.newLocal(Type.getType(this.type));
        it.store(ctx);
        Type forEachType = this.forEach.apply(this.getValue(it)).load(ctx);
        if (forEachType.getSize() == 1) {
            g.pop();
        }
        if (forEachType.getSize() == 2) {
            g.pop2();
        }
        g.goTo(labelLoop);
        g.mark(labelExit);
        return Type.VOID_TYPE;
    }

    public Type arrayForEach(Context ctx, GeneratorAdapter g, Label labelLoop, Label labelExit) {
        VarLocal len = ctx.newLocal(Type.INT_TYPE);
        g.arrayLength();
        len.store(ctx);
        g.push(0);
        VarLocal varPosition = ctx.newLocal(Type.INT_TYPE);
        varPosition.store(ctx);
        g.mark(labelLoop);
        varPosition.load(ctx);
        len.load(ctx);
        g.ifCmp(Type.INT_TYPE, 156, labelExit);
        this.collection.load(ctx);
        varPosition.load(ctx);
        g.arrayLoad(Type.getType(this.type));
        VarLocal it = ctx.newLocal(Type.getType(this.type));
        it.store(ctx);
        this.forEach.apply(this.getValue(it)).load(ctx);
        varPosition.load(ctx);
        g.push(1);
        g.math(96, Type.INT_TYPE);
        varPosition.store(ctx);
        g.goTo(labelLoop);
        g.mark(labelExit);
        return Type.VOID_TYPE;
    }
}

