/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

final class ExpressionCast
implements Expression {
    static final Type SELF_TYPE = Type.getType(Object.class);
    private final Expression expression;
    private final Type targetType;

    ExpressionCast(@NotNull Expression expression, @NotNull Type type) {
        this.expression = expression;
        this.targetType = type;
    }

    @Override
    public Type load(Context ctx) {
        Type targetType = this.targetType == SELF_TYPE ? ctx.getSelfType() : this.targetType;
        ctx.cast(this.expression.load(ctx), targetType);
        return targetType;
    }
}

