/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.ClassBuilder;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.VarLocal;
import io.activej.codegen.util.Utils;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class Context {
    private final DefiningClassLoader classLoader;
    private final ClassBuilder<?> classBuilder;
    private final GeneratorAdapter g;
    private final Type selfType;
    private final Method method;

    public Context(DefiningClassLoader classLoader, ClassBuilder<?> builder, GeneratorAdapter g, Type selfType, Method method) {
        this.classLoader = classLoader;
        this.classBuilder = builder;
        this.g = g;
        this.selfType = selfType;
        this.method = method;
    }

    public DefiningClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassBuilder<?> getClassBuilder() {
        return this.classBuilder;
    }

    public GeneratorAdapter getGeneratorAdapter() {
        return this.g;
    }

    public Type getSelfType() {
        return this.selfType;
    }

    public Class<?> getSuperclass() {
        return this.classBuilder.superclass;
    }

    public List<Class<?>> getInterfaces() {
        return this.classBuilder.interfaces;
    }

    public Map<String, Class<?>> getFields() {
        return this.classBuilder.fields;
    }

    public Map<Method, Expression> getMethods() {
        return this.classBuilder.methods;
    }

    public Map<Method, Expression> getStaticMethods() {
        return this.classBuilder.staticMethods;
    }

    public Method getMethod() {
        return this.method;
    }

    public VarLocal newLocal(Type type) {
        int local = this.getGeneratorAdapter().newLocal(type);
        return new VarLocal(local);
    }

    public Class<?> toJavaType(Type type) {
        if (type.equals((Object)this.getSelfType())) {
            throw new IllegalArgumentException();
        }
        int sort = type.getSort();
        if (sort == 1) {
            return Boolean.TYPE;
        }
        if (sort == 2) {
            return Character.TYPE;
        }
        if (sort == 3) {
            return Byte.TYPE;
        }
        if (sort == 4) {
            return Short.TYPE;
        }
        if (sort == 5) {
            return Integer.TYPE;
        }
        if (sort == 6) {
            return Float.TYPE;
        }
        if (sort == 7) {
            return Long.TYPE;
        }
        if (sort == 8) {
            return Double.TYPE;
        }
        if (sort == 0) {
            return Void.TYPE;
        }
        if (sort == 10) {
            try {
                return this.classLoader.loadClass(type.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("No class %s in class loader", type.getClassName()), e);
            }
        }
        if (sort == 9) {
            Class result;
            if (type.equals((Object)Type.getType(Object[].class))) {
                result = Object[].class;
            } else {
                String className = type.getDescriptor().replace('/', '.');
                try {
                    result = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(String.format("No class %s in Class.forName", className), e);
                }
            }
            return result;
        }
        throw new IllegalArgumentException(String.format("No Java type for %s", type.getClassName()));
    }

    public void cast(Type typeFrom, Type typeTo) {
        GeneratorAdapter g = this.getGeneratorAdapter();
        if (typeFrom.equals((Object)typeTo)) {
            return;
        }
        if (typeTo == Type.VOID_TYPE) {
            if (typeFrom.getSize() == 1) {
                g.pop();
            }
            if (typeFrom.getSize() == 2) {
                g.pop2();
            }
            return;
        }
        if (typeFrom == Type.VOID_TYPE) {
            throw new RuntimeException(String.format("Can't cast VOID_TYPE typeTo %s. %s", typeTo.getClassName(), Utils.exceptionInGeneratedClass(this)));
        }
        if (typeFrom.equals((Object)this.getSelfType())) {
            Class<?> javaType = this.toJavaType(typeTo);
            if (javaType.isAssignableFrom(this.getSuperclass())) {
                return;
            }
            for (Class<?> type : this.getInterfaces()) {
                if (!javaType.isAssignableFrom(type)) continue;
                return;
            }
            throw new RuntimeException(String.format("Can't cast self %s typeTo %s, %s", typeFrom.getClassName(), typeTo.getClassName(), Utils.exceptionInGeneratedClass(this)));
        }
        if (!typeFrom.equals((Object)this.getSelfType()) && !typeTo.equals((Object)this.getSelfType()) && this.toJavaType(typeTo).isAssignableFrom(this.toJavaType(typeFrom))) {
            return;
        }
        if (typeTo.equals((Object)Type.getType(Object.class)) && Utils.isPrimitiveType(typeFrom)) {
            g.box(typeFrom);
            return;
        }
        if ((Utils.isPrimitiveType(typeFrom) || Utils.isWrapperType(typeFrom)) && (Utils.isPrimitiveType(typeTo) || Utils.isWrapperType(typeTo))) {
            Type targetTypePrimitive;
            Type type = targetTypePrimitive = Utils.isPrimitiveType(typeTo) ? typeTo : Utils.unwrap(typeTo);
            if (Utils.isWrapperType(typeFrom)) {
                g.invokeVirtual(typeFrom, Utils.toPrimitive(typeTo));
                return;
            }
            assert (Utils.isPrimitiveType(typeFrom));
            if (Utils.isValidCast(typeFrom, targetTypePrimitive)) {
                g.cast(typeFrom, targetTypePrimitive);
            }
            if (Utils.isWrapperType(typeTo)) {
                g.valueOf(targetTypePrimitive);
            }
            return;
        }
        g.checkCast(typeTo);
    }

    public Type invoke(Expression owner, String methodName, Expression ... arguments) {
        return this.invoke(owner, methodName, Arrays.asList(arguments));
    }

    public Type invoke(Expression owner, String methodName, List<Expression> arguments) {
        Type ownerType = owner.load(this);
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            Expression argument = arguments.get(i);
            argumentTypes[i] = argument.load(this);
        }
        return this.invoke(ownerType, methodName, argumentTypes);
    }

    public Type invoke(Type ownerType, String methodName, Type ... argumentTypes) {
        Method foundMethod;
        Class[] arguments = (Class[])Stream.of(argumentTypes).map(this::toJavaType).toArray(Class[]::new);
        if (ownerType.equals((Object)this.getSelfType())) {
            foundMethod = this.findMethod(this.getMethods().keySet().stream(), methodName, arguments);
            this.g.invokeVirtual(ownerType, foundMethod);
        } else {
            Class<?> javaOwnerType = this.toJavaType(ownerType);
            foundMethod = this.findMethod(Arrays.stream(javaOwnerType.getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(Method::getMethod), methodName, arguments);
            if (javaOwnerType.isInterface()) {
                this.g.invokeInterface(ownerType, foundMethod);
            } else {
                this.g.invokeVirtual(ownerType, foundMethod);
            }
        }
        return foundMethod.getReturnType();
    }

    public Type invokeStatic(Type ownerType, String methodName, Expression ... arguments) {
        return this.invokeStatic(ownerType, methodName, Arrays.asList(arguments));
    }

    public Type invokeStatic(Type ownerType, String methodName, List<Expression> arguments) {
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            Expression argument = arguments.get(i);
            argumentTypes[i] = argument.load(this);
        }
        return this.invokeStatic(ownerType, methodName, argumentTypes);
    }

    public Type invokeStatic(Type ownerType, String methodName, Type ... argumentTypes) {
        Class[] arguments = (Class[])Stream.of(argumentTypes).map(this::toJavaType).toArray(Class[]::new);
        Method foundMethod = ownerType.equals((Object)this.getSelfType()) ? this.findMethod(this.getStaticMethods().keySet().stream(), methodName, arguments) : this.findMethod(Arrays.stream(this.toJavaType(ownerType).getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).map(Method::getMethod), methodName, arguments);
        this.g.invokeStatic(ownerType, foundMethod);
        return foundMethod.getReturnType();
    }

    public Type invokeConstructor(Type ownerType, Expression ... arguments) {
        return this.invokeConstructor(ownerType, Arrays.asList(arguments));
    }

    public Type invokeConstructor(Type ownerType, List<Expression> arguments) {
        this.g.newInstance(ownerType);
        this.g.dup();
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentTypes[i] = arguments.get(i).load(this);
        }
        return this.invokeConstructor(ownerType, argumentTypes);
    }

    public Type invokeConstructor(Type ownerType, Type ... argumentTypes) {
        Class[] arguments = (Class[])Stream.of(argumentTypes).map(this::toJavaType).toArray(Class[]::new);
        if (ownerType.equals((Object)this.getSelfType())) {
            throw new IllegalArgumentException();
        }
        Method foundMethod = this.findMethod(Arrays.stream(this.toJavaType(ownerType).getConstructors()).map(Method::getMethod), "<init>", arguments);
        this.g.invokeConstructor(ownerType, foundMethod);
        return ownerType;
    }

    private Method findMethod(Stream<Method> methods, String name, Class<?>[] arguments) {
        Set methodSet = methods.collect(Collectors.toSet());
        methodSet.addAll(Arrays.stream(Object.class.getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(Method::getMethod).collect(Collectors.toSet()));
        Method foundMethod = null;
        Class[] foundMethodArguments = null;
        for (Method method : methodSet) {
            Class[] methodArguments;
            if (!name.equals(method.getName()) || !Context.isAssignable(methodArguments = (Class[])Stream.of(method.getArgumentTypes()).map(this::toJavaType).toArray(Class[]::new), arguments)) continue;
            if (foundMethod == null) {
                foundMethod = method;
                foundMethodArguments = methodArguments;
                continue;
            }
            if (Context.isAssignable(foundMethodArguments, methodArguments)) {
                foundMethod = method;
                foundMethodArguments = methodArguments;
                continue;
            }
            if (Context.isAssignable(methodArguments, foundMethodArguments)) continue;
            throw new IllegalArgumentException("Ambiguous method: " + method + " " + Arrays.toString(arguments));
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException("Method not found: " + name + " " + Arrays.toString(arguments));
        }
        return foundMethod;
    }

    private static boolean isAssignable(Class<?>[] to, Class<?>[] from) {
        if (to.length != from.length) {
            return false;
        }
        return IntStream.range(0, from.length).allMatch(i -> to[i].isAssignableFrom(from[i]));
    }
}

