/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.DefiningClassLoaderMBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefiningClassLoader
extends ClassLoader
implements DefiningClassLoaderMBean {
    private final AtomicInteger definedClasses = new AtomicInteger();
    private final Map<@NotNull ClassKey, Class<?>> cachedClasses = new HashMap();

    private DefiningClassLoader() {
    }

    private DefiningClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static DefiningClassLoader create() {
        return new DefiningClassLoader();
    }

    public static DefiningClassLoader create(ClassLoader parent) {
        return new DefiningClassLoader(parent);
    }

    public Class<?> defineClass(String className, byte[] bytecode) {
        Class<?> definedClass = this.defineClass(className, bytecode, 0, bytecode.length);
        this.definedClasses.incrementAndGet();
        return definedClass;
    }

    public synchronized Class<?> defineAndCacheClass(@Nullable ClassKey key, String className, byte[] bytecode) {
        Class<?> definedClass = this.defineClass(className, bytecode);
        if (key != null) {
            this.cachedClasses.put(key, definedClass);
        }
        return definedClass;
    }

    @Nullable
    public synchronized Class<?> getCachedClass(@NotNull ClassKey key) {
        return this.cachedClasses.get(key);
    }

    @Override
    public synchronized int getDefinedClassesCount() {
        return this.cachedClasses.size();
    }

    @Override
    public synchronized int getCachedClassesCount() {
        return this.cachedClasses.size();
    }

    @Override
    public synchronized Map<String, Long> getCachedClassesCountByType() {
        return this.cachedClasses.keySet().stream().map(key -> Stream.concat(Stream.of(((ClassKey)key).superclass), ((ClassKey)key).interfaces.stream()).collect(Collectors.toList()).toString()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    public String toString() {
        return "{classes=" + this.cachedClasses.size() + ", byType=" + this.getCachedClassesCountByType() + '}';
    }

    public static final class ClassKey {
        private final Class<?> superclass;
        private final Set<Class<?>> interfaces;
        private final List<Object> parameters;

        public ClassKey(Class<?> superclass, Set<Class<?>> interfaces, List<Object> parameters) {
            this.superclass = superclass;
            this.interfaces = interfaces;
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassKey key = (ClassKey)o;
            return this.superclass.equals(key.superclass) && this.interfaces.equals(key.interfaces) && this.parameters.equals(key.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.superclass, this.interfaces, this.parameters);
        }
    }
}

