/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.Context;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.ExpressionConstant;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.util.DefiningClassWriter;
import io.activej.codegen.util.WithInitializer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassBuilder<T>
implements WithInitializer<ClassBuilder<T>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String CLASS_BUILDER_MARKER = "$GENERATED";
    public static final String DEFAULT_CLASS_NAME = ClassBuilder.class.getPackage().getName() + ".Class";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final ConcurrentHashMap<Integer, Object> STATIC_CONSTANTS = new ConcurrentHashMap();
    private final DefiningClassLoader classLoader;
    protected final Class<?> superclass;
    protected final List<Class<?>> interfaces;
    @Nullable
    private DefiningClassLoader.ClassKey classKey;
    private Path bytecodeSaveDir;
    private String className;
    protected final Map<String, Class<?>> fields = new LinkedHashMap();
    private final Set<String> fieldsFinal = new HashSet<String>();
    private final Set<String> fieldsStatic = new HashSet<String>();
    private final Map<String, Expression> fieldExpressions = new HashMap<String, Expression>();
    protected final Map<Method, Expression> methods = new LinkedHashMap<Method, Expression>();
    protected final Map<Method, Expression> staticMethods = new LinkedHashMap<Method, Expression>();
    private final List<Expression> initializers = new ArrayList<Expression>();
    private final List<Expression> staticInitializers = new ArrayList<Expression>();

    private ClassBuilder(DefiningClassLoader classLoader, Class<?> superclass, List<Class<?>> types) {
        this.classLoader = classLoader;
        this.superclass = superclass;
        this.interfaces = types;
        this.classKey = null;
        this.withStaticField(CLASS_BUILDER_MARKER, Void.class);
    }

    public static <T> ClassBuilder<T> create(DefiningClassLoader classLoader, Class<? super T> implementation, Class<?> ... interfaces) {
        return ClassBuilder.create(classLoader, implementation, Arrays.asList(interfaces));
    }

    public static <T> ClassBuilder<T> create(DefiningClassLoader classLoader, Class<? super T> implementation, List<Class<?>> interfaces) {
        if (!interfaces.stream().allMatch(Class::isInterface)) {
            throw new IllegalArgumentException();
        }
        if (implementation.isInterface()) {
            return new ClassBuilder<T>(classLoader, Object.class, Stream.concat(Stream.of(implementation), interfaces.stream()).collect(Collectors.toList()));
        }
        return new ClassBuilder<T>(classLoader, implementation, interfaces);
    }

    public ClassBuilder<T> withBytecodeSaveDir(Path bytecodeSaveDir) {
        this.bytecodeSaveDir = bytecodeSaveDir;
        return this;
    }

    public ClassBuilder<T> withClassKey(Object ... keyParameters) {
        this.classKey = keyParameters != null ? new DefiningClassLoader.ClassKey(this.superclass, new HashSet(this.interfaces), Arrays.asList(keyParameters)) : null;
        return this;
    }

    public ClassBuilder<T> withClassName(String name) {
        this.className = name;
        return this;
    }

    public ClassBuilder<T> withStaticInitializer(Expression expression) {
        this.staticInitializers.add(expression);
        return this;
    }

    public ClassBuilder<T> withConstructor(Expression expression) {
        this.initializers.add(expression);
        return this;
    }

    public ClassBuilder<T> withField(String field, Class<?> type) {
        this.fields.put(field, type);
        return this;
    }

    public ClassBuilder<T> withField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldExpressions.put(field, value);
        return this;
    }

    public ClassBuilder<T> withFinalField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldsFinal.add(field);
        this.fieldExpressions.put(field, value);
        return this;
    }

    public ClassBuilder<T> withMethod(String methodName, Class<?> returnType, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.methods.put(new Method(methodName, Type.getType(returnType), (Type[])argumentTypes.stream().map(Type::getType).toArray(Type[]::new)), expression);
        return this;
    }

    public ClassBuilder<T> withMethod(String methodName, Expression expression) {
        if (methodName.contains("(")) {
            Method method = Method.getMethod((String)methodName);
            this.methods.put(method, expression);
            return this;
        }
        Method foundMethod = null;
        ArrayList<List<java.lang.reflect.Method>> listOfMethods = new ArrayList<List<java.lang.reflect.Method>>();
        listOfMethods.add(Arrays.asList(Object.class.getMethods()));
        listOfMethods.add(Arrays.asList(this.superclass.getMethods()));
        listOfMethods.add(Arrays.asList(this.superclass.getDeclaredMethods()));
        for (Class<?> clazz : this.interfaces) {
            listOfMethods.add(Arrays.asList(clazz.getMethods()));
            listOfMethods.add(Arrays.asList(clazz.getDeclaredMethods()));
        }
        for (List list : listOfMethods) {
            for (java.lang.reflect.Method m : list) {
                if (!m.getName().equals(methodName)) continue;
                Method method = Method.getMethod((java.lang.reflect.Method)m);
                if (foundMethod != null && !method.equals((Object)foundMethod)) {
                    throw new IllegalArgumentException("Method " + method + " collides with " + foundMethod);
                }
                foundMethod = method;
            }
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException(String.format("Could not find method '%s'", methodName));
        }
        this.methods.put(foundMethod, expression);
        return this;
    }

    public ClassBuilder<T> withStaticMethod(String methodName, Class<?> returnClass, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.setStaticMethod(methodName, returnClass, argumentTypes, expression);
        return this;
    }

    public void setStaticMethod(String methodName, Class<?> returnClass, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.staticMethods.put(new Method(methodName, Type.getType(returnClass), (Type[])argumentTypes.stream().map(Type::getType).toArray(Type[]::new)), expression);
    }

    public ClassBuilder<T> withStaticField(String field, Class<?> type) {
        this.fields.put(field, type);
        this.fieldsStatic.add(field);
        return this;
    }

    public ClassBuilder<T> withStaticField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldsStatic.add(field);
        this.fieldExpressions.put(field, value);
        return this;
    }

    public ClassBuilder<T> withStaticFinalField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldsStatic.add(field);
        this.fieldsFinal.add(field);
        if (value instanceof ExpressionConstant && !((ExpressionConstant)value).isJvmPrimitive()) {
            STATIC_CONSTANTS.put(((ExpressionConstant)value).getId(), ((ExpressionConstant)value).getValue());
        }
        this.fieldExpressions.put(field, value);
        return this;
    }

    public static Object getStaticConstant(int id) {
        return STATIC_CONSTANTS.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Class<T> build() {
        byte[] bytecode;
        block12: {
            Class<?> cachedClass;
            Class<?> cachedClass2;
            if (this.classKey != null && (cachedClass2 = this.classLoader.getCachedClass(this.classKey)) != null) {
                return cachedClass2;
            }
            bytecode = this.defineNewClass(this.className != null ? this.className : DEFAULT_CLASS_NAME + COUNTER.incrementAndGet());
            DefiningClassLoader definingClassLoader = this.classLoader;
            // MONITORENTER : definingClassLoader
            if (this.classKey == null || (cachedClass = this.classLoader.getCachedClass(this.classKey)) == null) break block12;
            Class<?> clazz = cachedClass;
            // MONITOREXIT : definingClassLoader
            Iterator<Expression> iterator = this.fieldExpressions.values().iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                if (!(expression instanceof ExpressionConstant)) continue;
                STATIC_CONSTANTS.remove(((ExpressionConstant)expression).getId());
            }
            return clazz;
        }
        Class<?> aClass = this.classLoader.defineAndCacheClass(this.classKey, this.className, bytecode);
        try {
            Field field = aClass.getField(CLASS_BUILDER_MARKER);
            field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        Class<?> clazz = aClass;
        // MONITOREXIT : definingClassLoader
        Iterator<Expression> iterator = this.fieldExpressions.values().iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            if (!(expression instanceof ExpressionConstant)) continue;
            STATIC_CONSTANTS.remove(((ExpressionConstant)expression).getId());
        }
        return clazz;
        catch (Throwable throwable) {
            Iterator<Expression> iterator2 = this.fieldExpressions.values().iterator();
            while (iterator2.hasNext()) {
                Expression expression = iterator2.next();
                if (!(expression instanceof ExpressionConstant)) continue;
                STATIC_CONSTANTS.remove(((ExpressionConstant)expression).getId());
            }
            throw throwable;
        }
    }

    private byte[] defineNewClass(String actualClassName) {
        DefiningClassWriter cw = DefiningClassWriter.create(this.classLoader);
        Type classType = Type.getType((String)('L' + actualClassName.replace('.', '/') + ';'));
        cw.visit(50, 49, classType.getInternalName(), null, Type.getInternalName(this.superclass), (String[])this.interfaces.stream().map(Type::getInternalName).toArray(String[]::new));
        Method m = Method.getMethod((String)"void <init> ()");
        GeneratorAdapter g = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        g.loadThis();
        g.invokeConstructor(Type.getType(this.superclass), m);
        Context ctx = new Context(this.classLoader, this, g, classType, m);
        for (String field : this.fieldExpressions.keySet()) {
            if (this.fieldsStatic.contains(field)) continue;
            Expression expression = this.fieldExpressions.get(field);
            Expressions.set(Expressions.property(Expressions.self(), field), expression).load(ctx);
        }
        for (Expression initializer : this.initializers) {
            initializer.load(ctx);
        }
        g.returnValue();
        g.endMethod();
        HashSet<Method> methods = new HashSet<Method>();
        HashSet<Method> staticMethods = new HashSet<Method>();
        HashSet<String> fields = new HashSet<String>();
        while (true) {
            Expression expression;
            Context ctx2;
            GeneratorAdapter g2;
            LinkedHashSet<String> newFields = new LinkedHashSet<String>(this.fields.keySet());
            newFields.removeAll(fields);
            LinkedHashSet<Method> newMethods = new LinkedHashSet<Method>(this.methods.keySet());
            newMethods.removeAll(methods);
            LinkedHashSet<Method> newStaticMethods = new LinkedHashSet<Method>(this.staticMethods.keySet());
            newStaticMethods.removeAll(staticMethods);
            if (newFields.isEmpty() && newMethods.isEmpty() && newStaticMethods.isEmpty()) break;
            for (String field : newFields) {
                cw.visitField(1 + (this.fieldsStatic.contains(field) ? 8 : 0) + (this.fieldsFinal.contains(field) ? 16 : 0), field, Type.getType(this.fields.get(field)).getDescriptor(), null, null);
            }
            for (Method m2 : newMethods) {
                try {
                    g2 = new GeneratorAdapter(17, m2, null, null, (ClassVisitor)cw);
                    ctx2 = new Context(this.classLoader, this, g2, classType, m2);
                    expression = this.methods.get(m2);
                    ctx2.cast(expression.load(ctx2), m2.getReturnType());
                    g2.returnValue();
                    g2.endMethod();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            for (Method m2 : newStaticMethods) {
                try {
                    g2 = new GeneratorAdapter(25, m2, null, null, (ClassVisitor)cw);
                    ctx2 = new Context(this.classLoader, this, g2, classType, m2);
                    expression = this.staticMethods.get(m2);
                    ctx2.cast(expression.load(ctx2), m2.getReturnType());
                    g2.returnValue();
                    g2.endMethod();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            fields.addAll(newFields);
            methods.addAll(newMethods);
            staticMethods.addAll(newStaticMethods);
        }
        Method m3 = Method.getMethod((String)"void <clinit> ()");
        GeneratorAdapter g3 = new GeneratorAdapter(9, m3, null, null, (ClassVisitor)cw);
        Context ctx3 = new Context(this.classLoader, this, g3, classType, m3);
        for (String field : this.fieldExpressions.keySet()) {
            if (!this.fieldsStatic.contains(field)) continue;
            Expression expression = this.fieldExpressions.get(field);
            if (expression instanceof ExpressionConstant && !((ExpressionConstant)expression).isJvmPrimitive()) {
                Expressions.set(Expressions.staticField(field), Expressions.cast(Expressions.staticCall(ClassBuilder.class, "getStaticConstant", Expressions.value(((ExpressionConstant)expression).getId())), this.fields.get(field))).load(ctx3);
                continue;
            }
            Expressions.set(Expressions.staticField(field), expression).load(ctx3);
        }
        for (Expression initializer : this.staticInitializers) {
            initializer.load(ctx3);
        }
        g3.returnValue();
        g3.endMethod();
        if (this.bytecodeSaveDir != null) {
            try (FileOutputStream fos = new FileOutputStream(this.bytecodeSaveDir.resolve(actualClassName + ".class").toFile());){
                fos.write(cw.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public T buildClassAndCreateNewInstance() {
        try {
            return this.build().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public T buildClassAndCreateNewInstance(Object ... constructorParameters) {
        Class[] constructorParameterTypes = new Class[constructorParameters.length];
        for (int i = 0; i < constructorParameters.length; ++i) {
            constructorParameterTypes[i] = constructorParameters[i].getClass();
        }
        return this.buildClassAndCreateNewInstance(constructorParameterTypes, constructorParameters);
    }

    public T buildClassAndCreateNewInstance(Class<?>[] constructorParameterTypes, Object[] constructorParameters) {
        try {
            return this.build().getConstructor(constructorParameterTypes).newInstance(constructorParameters);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public DefiningClassLoader getClassLoader() {
        return this.classLoader;
    }
}

