/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ExpressionStaticField
implements Variable {
    private final Class<?> owner;
    private final String name;

    ExpressionStaticField(Class<?> owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    @Override
    public Type load(Context ctx) {
        Type fieldType;
        try {
            Class<?> ownerJavaType = ctx.toJavaType(Type.getType(this.owner));
            Field field = ownerJavaType.getField(this.name);
            Class<?> type = field.getType();
            fieldType = Type.getType(type);
        }
        catch (NoSuchFieldException ignored) {
            throw new RuntimeException(String.format("No static field %s.%s %s", this.owner.getName(), this.name, Utils.exceptionInGeneratedClass(ctx)));
        }
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        g.getStatic(Type.getType(this.owner), this.name, fieldType);
        return fieldType;
    }

    @Override
    public Object beginStore(Context ctx) {
        return Type.getType(this.owner);
    }

    @Override
    public void store(Context ctx, Object storeContext, Type type) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        try {
            Field javaField = this.owner.getField(this.name);
            if (Modifier.isPublic(javaField.getModifiers()) && Modifier.isStatic(javaField.getModifiers())) {
                Type fieldType = Type.getType(javaField.getType());
                g.putStatic((Type)storeContext, this.name, fieldType);
                return;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        throw new RuntimeException(String.format("No static field or setter for class %s for field \"%s\". %s ", ((Type)storeContext).getClassName(), this.name, Utils.exceptionInGeneratedClass(ctx)));
    }
}

