/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.Context;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.util.DefiningClassWriter;
import io.activej.codegen.util.WithInitializer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassBuilder<T>
implements WithInitializer<ClassBuilder<T>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_CLASS_NAME = ClassBuilder.class.getPackage().getName() + ".Class";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final DefiningClassLoader classLoader;
    private final Class<?> superclass;
    private final List<Class<?>> interfaces;
    @Nullable
    private DefiningClassLoader.ClassKey classKey;
    private Path bytecodeSaveDir;
    private String className;
    private final Map<String, Class<?>> fields = new LinkedHashMap();
    private final Map<String, Class<?>> staticFields = new LinkedHashMap();
    private final Map<Method, Expression> methods = new LinkedHashMap<Method, Expression>();
    private final Map<Method, Expression> staticMethods = new LinkedHashMap<Method, Expression>();
    private final Map<String, Object> staticConstants = new LinkedHashMap<String, Object>();

    private ClassBuilder(DefiningClassLoader classLoader, Class<?> superclass, List<Class<?>> types) {
        this.classLoader = classLoader;
        this.superclass = superclass;
        this.interfaces = types;
        this.classKey = null;
    }

    public static <T> ClassBuilder<T> create(DefiningClassLoader classLoader, Class<? super T> implementation, Class<?> ... interfaces) {
        return ClassBuilder.create(classLoader, implementation, Arrays.asList(interfaces));
    }

    public static <T> ClassBuilder<T> create(DefiningClassLoader classLoader, Class<? super T> implementation, List<Class<?>> interfaces) {
        if (!interfaces.stream().allMatch(Class::isInterface)) {
            throw new IllegalArgumentException();
        }
        if (implementation.isInterface()) {
            return new ClassBuilder<T>(classLoader, Object.class, Stream.concat(Stream.of(implementation), interfaces.stream()).collect(Collectors.toList()));
        }
        return new ClassBuilder<T>(classLoader, implementation, interfaces);
    }

    public ClassBuilder<T> withBytecodeSaveDir(Path bytecodeSaveDir) {
        this.bytecodeSaveDir = bytecodeSaveDir;
        return this;
    }

    public ClassBuilder<T> withClassKey(Object ... keyParameters) {
        this.classKey = keyParameters != null ? new DefiningClassLoader.ClassKey(this.superclass, new HashSet(this.interfaces), Arrays.asList(keyParameters)) : null;
        return this;
    }

    public ClassBuilder<T> withClassName(String name) {
        this.className = name;
        return this;
    }

    public ClassBuilder<T> withField(String field, Class<?> fieldClass) {
        this.fields.put(field, fieldClass);
        return this;
    }

    public ClassBuilder<T> withFields(Map<String, Class<?>> fields) {
        this.fields.putAll(fields);
        return this;
    }

    public ClassBuilder<T> withMethod(String methodName, Class<?> returnType, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.methods.put(new Method(methodName, Type.getType(returnType), (Type[])argumentTypes.stream().map(Type::getType).toArray(Type[]::new)), expression);
        return this;
    }

    public ClassBuilder<T> withMethod(String methodName, Expression expression) {
        if (methodName.contains("(")) {
            Method method = Method.getMethod((String)methodName);
            this.methods.put(method, expression);
            return this;
        }
        Method foundMethod = null;
        ArrayList<List<java.lang.reflect.Method>> listOfMethods = new ArrayList<List<java.lang.reflect.Method>>();
        listOfMethods.add(Arrays.asList(Object.class.getMethods()));
        listOfMethods.add(Arrays.asList(this.superclass.getMethods()));
        listOfMethods.add(Arrays.asList(this.superclass.getDeclaredMethods()));
        for (Class<?> clazz : this.interfaces) {
            listOfMethods.add(Arrays.asList(clazz.getMethods()));
            listOfMethods.add(Arrays.asList(clazz.getDeclaredMethods()));
        }
        for (List list : listOfMethods) {
            for (java.lang.reflect.Method m : list) {
                if (!m.getName().equals(methodName)) continue;
                Method method = Method.getMethod((java.lang.reflect.Method)m);
                if (foundMethod != null && !method.equals((Object)foundMethod)) {
                    throw new IllegalArgumentException("Method " + method + " collides with " + foundMethod);
                }
                foundMethod = method;
            }
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException(String.format("Could not find method '%s'", methodName));
        }
        this.methods.put(foundMethod, expression);
        return this;
    }

    public ClassBuilder<T> withStaticMethod(String methodName, Class<?> returnClass, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.setStaticMethod(methodName, returnClass, argumentTypes, expression);
        return this;
    }

    public void setStaticMethod(String methodName, Class<?> returnClass, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.staticMethods.put(new Method(methodName, Type.getType(returnClass), (Type[])argumentTypes.stream().map(Type::getType).toArray(Type[]::new)), expression);
    }

    public ClassBuilder<T> withStaticField(String fieldName, Class<?> type, Object value) {
        this.staticFields.put(fieldName, type);
        this.staticConstants.put(fieldName, value);
        return this;
    }

    public Map<Method, Expression> getMethods() {
        return this.methods;
    }

    public Map<String, Class<?>> getFields() {
        return this.fields;
    }

    public Map<Method, Expression> getStaticMethods() {
        return this.staticMethods;
    }

    public Map<String, Class<?>> getStaticFields() {
        return this.staticFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<T> build() {
        Class<?> cachedClass;
        if (this.classKey != null && (cachedClass = this.classLoader.getCachedClass(this.classKey)) != null) {
            return cachedClass;
        }
        byte[] bytecode = this.defineNewClass(this.className != null ? this.className : DEFAULT_CLASS_NAME + COUNTER.incrementAndGet());
        DefiningClassLoader definingClassLoader = this.classLoader;
        synchronized (definingClassLoader) {
            Class<?> cachedClass2;
            if (this.classKey != null && (cachedClass2 = this.classLoader.getCachedClass(this.classKey)) != null) {
                return cachedClass2;
            }
            Class<?> definedClass = this.classLoader.defineAndCacheClass(this.classKey, this.className, bytecode);
            for (Map.Entry<String, Object> entry : this.staticConstants.entrySet()) {
                try {
                    Field field = definedClass.getField(entry.getKey());
                    field.set(null, entry.getValue());
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return definedClass;
        }
    }

    private byte[] defineNewClass(String actualClassName) {
        DefiningClassWriter cw = DefiningClassWriter.create(this.classLoader);
        Type classType = Type.getType((String)('L' + actualClassName.replace('.', '/') + ';'));
        cw.visit(50, 49, classType.getInternalName(), null, Type.getInternalName(this.superclass), (String[])this.interfaces.stream().map(Type::getInternalName).toArray(String[]::new));
        Method m = Method.getMethod((String)"void <init> ()");
        GeneratorAdapter generatorAdapter = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        generatorAdapter.loadThis();
        generatorAdapter.invokeConstructor(Type.getType(this.superclass), m);
        generatorAdapter.returnValue();
        generatorAdapter.endMethod();
        for (Map.Entry entry : this.fields.entrySet()) {
            cw.visitField(1, (String)entry.getKey(), Type.getType((Class)((Class)entry.getValue())).getDescriptor(), null, null);
        }
        HashSet<Map.Entry<String, Object>> methods = new HashSet<Map.Entry<String, Object>>();
        HashSet<Method> hashSet = new HashSet<Method>();
        while (true) {
            Expression expression;
            Context ctx;
            Iterator<Map.Entry<String, Object>> newMethods = new LinkedHashSet<Method>(this.methods.keySet());
            newMethods.removeAll(methods);
            LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>(this.staticMethods.keySet());
            linkedHashSet.removeAll(hashSet);
            if (newMethods.isEmpty() && linkedHashSet.isEmpty()) break;
            Iterator iterator = newMethods.iterator();
            while (iterator.hasNext()) {
                Method m2 = (Method)iterator.next();
                try {
                    GeneratorAdapter g2 = new GeneratorAdapter(1, m2, null, null, (ClassVisitor)cw);
                    ctx = new Context(this.classLoader, g2, classType, this.superclass, this.interfaces, this.fields, this.methods, this.staticMethods, m2, this.staticConstants);
                    expression = this.methods.get(m2);
                    ctx.cast(expression.load(ctx), m2.getReturnType());
                    g2.returnValue();
                    g2.endMethod();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            for (Method m2 : linkedHashSet) {
                try {
                    GeneratorAdapter g = new GeneratorAdapter(25, m2, null, null, (ClassVisitor)cw);
                    ctx = new Context(this.classLoader, g, classType, this.superclass, this.interfaces, this.fields, this.methods, this.staticMethods, m2, this.staticConstants);
                    expression = this.staticMethods.get(m2);
                    ctx.cast(expression.load(ctx), m2.getReturnType());
                    g.returnValue();
                    g.endMethod();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            methods.addAll((Collection<Map.Entry<String, Object>>)((Object)newMethods));
            hashSet.addAll(linkedHashSet);
        }
        for (Map.Entry entry : this.staticFields.entrySet()) {
            cw.visitField(9, (String)entry.getKey(), Type.getType((Class)((Class)entry.getValue())).getDescriptor(), null, null);
        }
        for (Map.Entry<String, Object> entry : this.staticConstants.entrySet()) {
            cw.visitField(9, entry.getKey(), Type.getType(entry.getValue().getClass()).getDescriptor(), null, null);
        }
        if (this.bytecodeSaveDir != null) {
            try (FileOutputStream fos = new FileOutputStream(this.bytecodeSaveDir.resolve(actualClassName + ".class").toFile());){
                fos.write(cw.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public T buildClassAndCreateNewInstance() {
        try {
            return this.build().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public T buildClassAndCreateNewInstance(Object ... constructorParameters) {
        Class[] constructorParameterTypes = new Class[constructorParameters.length];
        for (int i = 0; i < constructorParameters.length; ++i) {
            constructorParameterTypes[i] = constructorParameters[i].getClass();
        }
        return this.buildClassAndCreateNewInstance(constructorParameterTypes, constructorParameters);
    }

    public T buildClassAndCreateNewInstance(Class<?>[] constructorParameterTypes, Object[] constructorParameters) {
        try {
            return this.build().getConstructor(constructorParameterTypes).newInstance(constructorParameters);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public DefiningClassLoader getClassLoader() {
        return this.classLoader;
    }
}

