/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec.binary;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredEncoder;
import io.activej.codec.binary.BinaryStructuredInput;
import io.activej.codec.binary.BinaryStructuredOutput;
import io.activej.common.exception.parse.ParseException;

public final class BinaryUtils {
    public static <T> T decode(StructuredDecoder<T> decoder, byte[] bytes) throws ParseException {
        return BinaryUtils.decode(decoder, ByteBuf.wrapForReading((byte[])bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T decode(StructuredDecoder<T> decoder, ByteBuf buf) throws ParseException {
        try {
            BinaryStructuredInput in = new BinaryStructuredInput(buf);
            T result = decoder.decode(in);
            if (buf.readRemaining() != 0) {
                throw new ParseException("Byte buffer was not fully consumed when decoding");
            }
            T t = result;
            return t;
        }
        finally {
            buf.recycle();
        }
    }

    public static <T> ByteBuf encode(StructuredEncoder<T> encoder, T item) {
        BinaryStructuredOutput out = new BinaryStructuredOutput();
        encoder.encode(out, item);
        return out.getBuf();
    }

    public static <T> byte[] encodeAsArray(StructuredEncoder<T> encoder, T item) {
        return BinaryUtils.encode(encoder, item).asArray();
    }

    public static <T> void encodeInto(StructuredEncoder<T> encoder, T item, ByteBuf dest) {
        ByteBuf encoded = BinaryUtils.encode(encoder, item);
        dest.write(encoded.array(), encoded.head(), encoded.readRemaining());
    }

    public static <T> ByteBuf encodeWithSizePrefix(StructuredEncoder<T> encoder, T item) {
        BinaryStructuredOutput out = new BinaryStructuredOutput();
        encoder.encode(out, item);
        ByteBuf buf = ByteBufPool.allocate((int)(out.getBuf().readRemaining() + 5));
        buf.writeVarInt(out.getBuf().readRemaining());
        buf.write(out.getBuf().array(), out.getBuf().head(), out.getBuf().readRemaining());
        out.getBuf().recycle();
        return buf;
    }
}

