/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec.binary;

import io.activej.bytebuf.ByteBuf;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredInput;
import io.activej.common.exception.UncheckedException;
import io.activej.common.exception.parse.ParseException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class BinaryStructuredInput
implements StructuredInput {
    private final ByteBuf buf;

    public BinaryStructuredInput(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public boolean readBoolean() throws ParseException {
        try {
            return this.buf.readBoolean();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public byte readByte() throws ParseException {
        try {
            return this.buf.readByte();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public int readInt() throws ParseException {
        try {
            return this.buf.readVarInt();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public long readLong() throws ParseException {
        try {
            return this.buf.readVarLong();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public int readInt32() throws ParseException {
        try {
            return this.buf.readInt();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public long readLong64() throws ParseException {
        try {
            return this.buf.readLong();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public float readFloat() throws ParseException {
        try {
            return this.buf.readFloat();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public double readDouble() throws ParseException {
        try {
            return this.buf.readDouble();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException((Throwable)e);
        }
    }

    @Override
    public byte[] readBytes() throws ParseException {
        int length = this.readInt();
        if (length < 0 || length > this.buf.readRemaining()) {
            throw new ParseException("Invalid length: " + length + ", remaining: " + this.buf.readRemaining() + ", buf: " + this.buf);
        }
        byte[] result = new byte[length];
        this.buf.read(result);
        return result;
    }

    @Override
    public String readString() throws ParseException {
        int length = this.readInt();
        if (length == 0) {
            return "";
        }
        if (length > this.buf.readRemaining()) {
            throw new ParseException("Read string length is greater than the remaining data");
        }
        String result = new String(this.buf.array(), this.buf.head(), length, StandardCharsets.UTF_8);
        this.buf.moveHead(length);
        return result;
    }

    @Override
    public void readNull() throws ParseException {
        if (this.readBoolean()) {
            throw new ParseException("Expected NULL value");
        }
    }

    @Override
    @Nullable
    public <T> T readNullable(StructuredDecoder<T> decoder) throws ParseException {
        try {
            return this.readBoolean() ? (T)decoder.decode(this) : null;
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
    }

    @Override
    public <T> List<T> readList(StructuredDecoder<T> decoder) throws ParseException {
        int size = this.readInt();
        ArrayList<T> list = new ArrayList<T>(size);
        try {
            for (int i = 0; i < size; ++i) {
                list.add(decoder.decode(this));
            }
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
        return list;
    }

    @Override
    public <K, V> Map<K, V> readMap(StructuredDecoder<K> keyDecoder, StructuredDecoder<V> valueDecoder) throws ParseException {
        int size = this.readInt();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        try {
            for (int i = 0; i < size; ++i) {
                map.put(keyDecoder.decode(this), valueDecoder.decode(this));
            }
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
        return map;
    }

    @Override
    public <T> T readTuple(StructuredDecoder<T> decoder) throws ParseException {
        try {
            return decoder.decode(this);
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
    }

    @Override
    public <T> T readObject(StructuredDecoder<T> decoder) throws ParseException {
        try {
            return decoder.decode(this);
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
    }

    @Override
    public boolean hasNext() throws ParseException {
        throw new UnsupportedOperationException("hasNext() is not supported for binary data");
    }

    @Override
    public String readKey() throws ParseException {
        return this.readString();
    }

    @Override
    public <T> T readCustom(Type type) throws ParseException {
        throw new UnsupportedOperationException("No custom type readers");
    }

    @Override
    public EnumSet<StructuredInput.Token> getNext() throws ParseException {
        throw new UnsupportedOperationException("getNext() is not supported for binary data");
    }
}

