/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec.json;

import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.util.ByteBufWriter;
import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredEncoder;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.codec.json.JsonStructuredInput;
import io.activej.codec.json.JsonStructuredOutput;
import io.activej.common.exception.UncheckedException;
import io.activej.common.exception.parse.ParseException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class JsonUtils {
    public static <T> T fromJson(StructuredDecoder<T> decoder, String string) throws ParseException {
        T result;
        JsonReader reader = new JsonReader((Reader)new StringReader(string));
        try {
            result = decoder.decode(new JsonStructuredInput(reader));
        }
        catch (UncheckedException e) {
            throw (ParseException)e.propagate(ParseException.class);
        }
        try {
            if (reader.peek() != JsonToken.END_DOCUMENT) {
                throw new ParseException("Json data was not fully consumed when decoding");
            }
        }
        catch (MalformedJsonException | EOFException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        return result;
    }

    private static <T> void toJson(StructuredEncoder<T> encoder, T value, Writer writer) {
        JsonWriterEx jsonWriter = new JsonWriterEx(writer);
        jsonWriter.setLenient(true);
        jsonWriter.setIndentEx("");
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setSerializeNulls(true);
        encoder.encode(new JsonStructuredOutput(jsonWriter), value);
    }

    public static <T> String toJson(StructuredEncoder<? super T> encoder, T value) {
        StringWriter writer = new StringWriter();
        JsonUtils.toJson(encoder, value, writer);
        return writer.toString();
    }

    public static <T> ByteBuf toJsonBuf(StructuredEncoder<? super T> encoder, T value) {
        ByteBufWriter writer = new ByteBufWriter();
        JsonUtils.toJson(encoder, value, (Writer)writer);
        return writer.getBuf();
    }

    public static <T> void toJson(StructuredEncoder<? super T> encoder, T value, Appendable appendable) {
        JsonUtils.toJson(encoder, value, Streams.writerForAppendable((Appendable)appendable));
    }

    public static <T> StructuredCodec<T> oneline(StructuredCodec<T> codec) {
        return JsonUtils.indent(codec, "");
    }

    public static <T> StructuredCodec<T> indent(final StructuredCodec<T> codec, final String indent) {
        return new StructuredCodec<T>(){

            @Override
            public void encode(StructuredOutput out, T item) {
                if (out instanceof JsonStructuredOutput) {
                    JsonStructuredOutput jsonOut = (JsonStructuredOutput)out;
                    if (jsonOut.writer instanceof JsonWriterEx) {
                        JsonWriterEx jsonWriterEx = (JsonWriterEx)jsonOut.writer;
                        String previousIndent = jsonWriterEx.getIndentEx();
                        jsonWriterEx.setIndentEx(indent);
                        if (indent.isEmpty()) {
                            try {
                                jsonWriterEx.writer.write(10);
                            }
                            catch (IOException e) {
                                throw new AssertionError();
                            }
                        }
                        codec.encode(out, item);
                        jsonWriterEx.setIndentEx(previousIndent);
                        return;
                    }
                }
                codec.encode(out, item);
            }

            @Override
            public T decode(StructuredInput in) throws ParseException {
                return codec.decode(in);
            }
        };
    }

    public static final class JsonWriterEx
    extends JsonWriter {
        final Writer writer;
        private String indentEx;

        public JsonWriterEx(Writer writer) {
            super(writer);
            this.writer = writer;
        }

        public final void setIndentEx(String indent) {
            this.indentEx = indent;
            this.setIndent(indent);
        }

        public final String getIndentEx() {
            return this.indentEx;
        }
    }
}

