/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec;

import io.activej.codec.StructuredDecoder;
import io.activej.common.exception.parse.ParseException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface StructuredInput {
    public void readNull() throws ParseException;

    public boolean readBoolean() throws ParseException;

    public byte readByte() throws ParseException;

    public int readInt() throws ParseException;

    public long readLong() throws ParseException;

    public int readInt32() throws ParseException;

    public long readLong64() throws ParseException;

    public float readFloat() throws ParseException;

    public double readDouble() throws ParseException;

    public byte[] readBytes() throws ParseException;

    public String readString() throws ParseException;

    @Nullable
    public <T> T readNullable(StructuredDecoder<T> var1) throws ParseException;

    public boolean hasNext() throws ParseException;

    public String readKey() throws ParseException;

    default public void readKey(String expectedName) throws ParseException {
        String actualName = this.readKey();
        if (!expectedName.equals(actualName)) {
            throw new ParseException("Expected field: " + expectedName + ", but was: " + actualName);
        }
    }

    default public <T> T readKey(String expectedName, StructuredDecoder<T> decoder) throws ParseException {
        this.readKey(expectedName);
        return decoder.decode(this);
    }

    public <T> List<T> readList(StructuredDecoder<T> var1) throws ParseException;

    public <K, V> Map<K, V> readMap(StructuredDecoder<K> var1, StructuredDecoder<V> var2) throws ParseException;

    public <T> T readTuple(StructuredDecoder<T> var1) throws ParseException;

    public <T> T readObject(StructuredDecoder<T> var1) throws ParseException;

    default public void readTuple(ParserRunnable decoder) throws ParseException {
        this.readTuple((StructuredInput in) -> {
            decoder.run();
            return null;
        });
    }

    default public void readObject(ParserRunnable decoder) throws ParseException {
        this.readObject((StructuredInput in) -> {
            decoder.run();
            return null;
        });
    }

    public <T> T readCustom(Type var1) throws ParseException;

    public EnumSet<Token> getNext() throws ParseException;

    @FunctionalInterface
    public static interface ParserRunnable {
        public void run() throws ParseException;
    }

    public static enum Token {
        NULL,
        BOOLEAN,
        BYTE,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        BYTES,
        LIST,
        MAP,
        TUPLE,
        OBJECT;

    }
}

