/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec;

import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.common.api.WithInitializer;
import io.activej.common.exception.parse.ParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class CodecSubtype<T>
implements WithInitializer<CodecSubtype<T>>,
StructuredCodec<T> {
    private final Map<String, StructuredCodec<? extends T>> namesToAdapters = new HashMap<String, StructuredCodec<? extends T>>();
    private final Map<Type, String> subtypesToNames = new HashMap<Type, String>();
    @Nullable
    private String tagName = null;
    private String dataName = "data";

    private CodecSubtype() {
    }

    public static <T> CodecSubtype<T> create() {
        return new CodecSubtype<T>();
    }

    public CodecSubtype<T> withTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public CodecSubtype<T> withTagName(String tagName, String dataName) {
        this.tagName = tagName;
        this.dataName = dataName;
        return this;
    }

    public CodecSubtype<T> with(Type type, String name, StructuredCodec<? extends T> adapter) {
        this.namesToAdapters.put(name, adapter);
        this.subtypesToNames.put(type, name);
        return this;
    }

    public CodecSubtype<T> with(Type type, StructuredCodec<? extends T> adapter) {
        String name = type.getTypeName();
        name = name.substring(Math.max(name.lastIndexOf(46), name.lastIndexOf(36)) + 1);
        return this.with(type, name, adapter);
    }

    @Override
    public void encode(StructuredOutput out, T value) {
        out.writeObject(() -> {
            String tag = this.subtypesToNames.get(value.getClass());
            if (tag == null) {
                throw new IllegalArgumentException("Unregistered data type: " + value.getClass().getName());
            }
            StructuredCodec<Object> codec = this.namesToAdapters.get(tag);
            if (this.tagName != null) {
                out.writeKey(this.tagName);
                out.writeString(tag);
                out.writeKey(this.dataName);
            } else {
                out.writeKey(tag);
            }
            codec.encode(out, value);
        });
    }

    @Override
    public T decode(StructuredInput in) throws ParseException {
        return (T)in.readObject($ -> {
            String key;
            if (this.tagName != null) {
                in.readKey(this.tagName);
                key = in.readString();
                in.readKey(this.dataName);
            } else {
                key = in.readKey();
            }
            StructuredCodec<T> codec = this.namesToAdapters.get(key);
            if (codec == null) {
                throw new ParseException("Could not find codec for: " + key);
            }
            return codec.decode(in);
        });
    }
}

