/*
 * Decompiled with CFR 0.152.
 */
package io.activej.bytebuf;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.common.concurrent.ThreadLocalCharArray;
import io.activej.common.exception.parse.ParseException;

public final class ByteBufStrings {
    private static final boolean CHECK = Checks.isEnabled(ByteBufStrings.class);
    public static final ParseException READ_PAST_LIMIT = new ParseException(ByteBufStrings.class, "Malformed utf-8 input: Read past end");
    public static final ParseException READ_PAST_ARRAY_LENGTH = new ParseException(ByteBufStrings.class, "Malformed utf-8 input");
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte SP = 32;
    public static final byte HT = 9;
    private static final byte[] MIN_LONG_BYTES = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    private static final byte[] MIN_INT_BYTES = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};

    public static void encodeAscii(byte[] array, int pos, String string) {
        for (int i = 0; i < string.length(); ++i) {
            array[pos++] = (byte)string.charAt(i);
        }
    }

    public static byte[] encodeAscii(String string) {
        byte[] array = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            array[i] = (byte)string.charAt(i);
        }
        return array;
    }

    public static void putAscii(ByteBuf buf, String string) {
        ByteBufStrings.encodeAscii(buf.array(), buf.tail(), string);
        buf.moveTail(string.length());
    }

    public static ByteBuf wrapAscii(String string) {
        byte[] array = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            array[i] = (byte)string.charAt(i);
        }
        return ByteBuf.wrapForReading(array);
    }

    public static String decodeAscii(byte[] array, int pos, int len, char[] tmpBuffer) {
        if (CHECK) {
            Checks.checkArgument((tmpBuffer.length >= len ? 1 : 0) != 0, (Object)"given char buffer is not big enough");
        }
        int charIndex = 0;
        int end = pos + len;
        while (pos < end) {
            int c = array[pos++] & 0xFF;
            tmpBuffer[charIndex++] = (char)c;
        }
        return new String(tmpBuffer, 0, charIndex);
    }

    public static String decodeAscii(byte[] array, int pos, int len) {
        return ByteBufStrings.decodeAscii(array, pos, len, ThreadLocalCharArray.ensure((int)len));
    }

    public static String asAscii(ByteBuf buf) {
        String str = ByteBufStrings.decodeAscii(buf.array(), buf.head(), buf.readRemaining(), ThreadLocalCharArray.ensure((int)buf.readRemaining()));
        buf.recycle();
        return str;
    }

    public static String decodeAscii(byte[] array) {
        return ByteBufStrings.decodeAscii(array, 0, array.length, ThreadLocalCharArray.ensure((int)array.length));
    }

    public static void toLowerCaseAscii(byte[] bytes, int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            byte b = bytes[i];
            if (b < 65 || b > 90) continue;
            bytes[i] = (byte)(b + 32);
        }
    }

    public static void toLowerCaseAscii(byte[] bytes) {
        ByteBufStrings.toLowerCaseAscii(bytes, 0, bytes.length);
    }

    public static void toLowerCaseAscii(ByteBuf buf) {
        ByteBufStrings.toLowerCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static void toUpperCaseAscii(byte[] bytes, int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            byte b = bytes[i];
            if (b < 97 || b > 122) continue;
            bytes[i] = (byte)(b + -32);
        }
    }

    public static void toUpperCaseAscii(byte[] bytes) {
        ByteBufStrings.toUpperCaseAscii(bytes, 0, bytes.length);
    }

    public static void toUpperCaseAscii(ByteBuf buf) {
        ByteBufStrings.toUpperCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static boolean equalsLowerCaseAscii(byte[] lowerCasePattern, byte[] array, int offset, int size) {
        if (lowerCasePattern.length != size) {
            return false;
        }
        for (int i = 0; i < lowerCasePattern.length; ++i) {
            byte a;
            byte p = lowerCasePattern[i];
            if (CHECK) {
                Checks.checkArgument((p < 65 || p > 90 ? 1 : 0) != 0);
            }
            if ((a = array[offset + i]) >= 65 && a <= 90) {
                a = (byte)(a + 32);
            }
            if (a == p) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsUpperCaseAscii(byte[] upperCasePattern, byte[] array, int offset, int size) {
        if (upperCasePattern.length != size) {
            return false;
        }
        for (int i = 0; i < upperCasePattern.length; ++i) {
            byte a;
            byte p = upperCasePattern[i];
            if (CHECK) {
                Checks.checkArgument((p < 97 || p > 122 ? 1 : 0) != 0);
            }
            if ((a = array[offset + i]) >= 97 && a <= 122) {
                a = (byte)(a - 57);
            }
            if (a == p) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(byte[] array, int offset, int size) {
        int result = 1;
        for (int i = offset; i < offset + size; ++i) {
            result = 31 * result + array[i];
        }
        return result;
    }

    public static int hashCode(byte[] array) {
        return ByteBufStrings.hashCode(array, 0, array.length);
    }

    public static int hashCode(ByteBuf buf) {
        return ByteBufStrings.hashCode(buf.array(), buf.head(), buf.readRemaining());
    }

    public static int hashCodeLowerCaseAscii(byte[] array, int offset, int size) {
        int result = 1;
        for (int i = offset; i < offset + size; ++i) {
            byte a = array[i];
            if (a >= 65 && a <= 90) {
                a = (byte)(a + 32);
            }
            result = 31 * result + a;
        }
        return result;
    }

    public static int hashCodeLowerCaseAscii(byte[] array) {
        return ByteBufStrings.hashCodeLowerCaseAscii(array, 0, array.length);
    }

    public static int hashCodeLowerCaseAscii(ByteBuf buf) {
        return ByteBufStrings.hashCodeLowerCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static int hashCodeUpperCaseAscii(byte[] array, int offset, int size) {
        int result = 1;
        for (int i = offset; i < offset + size; ++i) {
            byte a = array[i];
            if (a >= 97 && a <= 122) {
                a = (byte)(a - 32);
            }
            result = 31 * result + a;
        }
        return result;
    }

    public static int hashCodeUpperCaseAscii(byte[] array) {
        return ByteBufStrings.hashCodeUpperCaseAscii(array, 0, array.length);
    }

    public static int hashCodeUpperCaseAscii(ByteBuf buf) {
        return ByteBufStrings.hashCodeUpperCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static int encodeUtf8(byte[] array, int pos, String string) {
        int p = pos;
        for (int i = 0; i < string.length(); ++i) {
            p += ByteBufStrings.encodeUtf8(array, p, string.charAt(i));
        }
        return p - pos;
    }

    public static int encodeUtf8(byte[] array, int pos, char c) {
        int p = pos;
        if (c <= '\u007f') {
            array[p++] = (byte)c;
        } else if (c > '\u07ff') {
            array[p++] = (byte)(0xE0 | c >> 12 & 0xF);
            array[p++] = (byte)(0x80 | c >> 6 & 0x3F);
            array[p++] = (byte)(0x80 | c & 0x3F);
        } else {
            array[p++] = (byte)(0xC0 | c >> 6 & 0x1F);
            array[p++] = (byte)(0x80 | c & 0x3F);
        }
        return p - pos;
    }

    public static void putUtf8(ByteBuf buf, String string) {
        int size = ByteBufStrings.encodeUtf8(buf.array(), buf.tail(), string);
        buf.moveTail(size);
    }

    public static void putUtf8(ByteBuf buf, char c) {
        int size = ByteBufStrings.encodeUtf8(buf.array(), buf.tail(), c);
        buf.moveTail(size);
    }

    public static ByteBuf wrapUtf8(String string) {
        ByteBuf byteBuffer = ByteBufPool.allocate(string.length() * 3);
        int size = ByteBufStrings.encodeUtf8(byteBuffer.array(), 0, string);
        byteBuffer.moveTail(size);
        return byteBuffer;
    }

    public static int decodeUtf8(byte[] array, int pos, int len, char[] buffer, int to) throws ParseException {
        int end = pos + len;
        try {
            while (pos < end) {
                int c = array[pos++] & 0xFF;
                switch (c >> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        buffer[to++] = (char)c;
                        break;
                    }
                    case 12: 
                    case 13: {
                        buffer[to++] = (char)((c & 0x1F) << 6 | array[pos++] & 0x3F);
                        break;
                    }
                    case 14: {
                        buffer[to++] = (char)((c & 0xF) << 12 | (array[pos++] & 0x3F) << 6 | array[pos++] & 0x3F);
                    }
                }
            }
            if (pos > end) {
                throw READ_PAST_LIMIT;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw READ_PAST_ARRAY_LENGTH;
        }
        return to;
    }

    public static String decodeUtf8(byte[] array, int pos, int len, char[] tmpBuffer) throws ParseException {
        int charIndex = 0;
        charIndex = ByteBufStrings.decodeUtf8(array, pos, len, tmpBuffer, charIndex);
        return new String(tmpBuffer, 0, charIndex);
    }

    public static String decodeUtf8(byte[] array, int pos, int len) throws ParseException {
        return ByteBufStrings.decodeUtf8(array, pos, len, ThreadLocalCharArray.ensure((int)len));
    }

    public static String decodeUtf8(ByteBuf buf, char[] tmpBuffer) throws ParseException {
        return ByteBufStrings.decodeUtf8(buf.array(), buf.head(), buf.readRemaining(), tmpBuffer);
    }

    public static String decodeUtf8(ByteBuf buf) throws ParseException {
        return ByteBufStrings.decodeUtf8(buf.array(), buf.head(), buf.readRemaining(), new char[buf.readRemaining()]);
    }

    public static String decodeUtf8(byte[] array) throws ParseException {
        return ByteBufStrings.decodeUtf8(array, 0, array.length, new char[array.length]);
    }

    public static String asUtf8(ByteBuf buf) throws ParseException {
        String str = ByteBufStrings.decodeUtf8(buf.array(), buf.head(), buf.readRemaining(), ThreadLocalCharArray.ensure((int)buf.readRemaining()));
        buf.recycle();
        return str;
    }

    public static int encodeInt(byte[] array, int pos, int value) {
        if (value >= 0) {
            return ByteBufStrings.encodePositiveInt(array, pos, value);
        }
        return ByteBufStrings.encodeNegativeInt(array, pos, value);
    }

    public static int encodePositiveInt(byte[] array, int pos, int value) {
        int digits = ByteBufStrings.digitsInt(value);
        for (int i = pos + digits - 1; i >= pos; --i) {
            long digit = value % 10;
            value /= 10;
            array[i] = (byte)(48L + digit);
        }
        return digits;
    }

    private static int encodeNegativeInt(byte[] array, int pos, int value) {
        if (value == Integer.MIN_VALUE) {
            System.arraycopy(MIN_INT_BYTES, 0, array, pos, 11);
            return 11;
        }
        value = -value;
        int digits = ByteBufStrings.digitsInt(value);
        for (int i = pos + digits; i >= pos + 1; --i) {
            int digit = value % 10;
            value /= 10;
            array[i] = (byte)(48 + digit);
        }
        array[i] = 45;
        return digits + 1;
    }

    public static int encodeLong(byte[] array, int pos, long value) {
        if (value >= 0L) {
            return ByteBufStrings.encodePositiveLong(array, pos, value);
        }
        return ByteBufStrings.encodeNegativeLong(array, pos, value);
    }

    public static int encodePositiveLong(byte[] array, int pos, long value) {
        int digits = ByteBufStrings.digitsLong(value);
        for (int i = pos + digits - 1; i >= pos; --i) {
            long digit = value % 10L;
            value /= 10L;
            array[i] = (byte)(48L + digit);
        }
        return digits;
    }

    private static int encodeNegativeLong(byte[] array, int pos, long value) {
        if (value == Long.MIN_VALUE) {
            System.arraycopy(MIN_LONG_BYTES, 0, array, pos, 20);
            return 20;
        }
        value = -value;
        int digits = ByteBufStrings.digitsLong(value);
        for (int i = pos + digits; i >= pos + 1; --i) {
            long digit = value % 10L;
            value /= 10L;
            array[i] = (byte)(48L + digit);
        }
        array[i] = 45;
        return digits + 1;
    }

    public static void putInt(ByteBuf buf, int value) {
        int digits = ByteBufStrings.encodeInt(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static void putPositiveInt(ByteBuf buf, int value) {
        int digits = ByteBufStrings.encodePositiveInt(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static void putLong(ByteBuf buf, long value) {
        int digits = ByteBufStrings.encodeLong(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static void putPositiveLong(ByteBuf buf, long value) {
        int digits = ByteBufStrings.encodePositiveLong(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static ByteBuf wrapInt(int value) {
        ByteBuf buf = ByteBufPool.allocate(11);
        int digits = ByteBufStrings.encodeInt(buf.array, 0, value);
        buf.moveTail(digits);
        return buf;
    }

    public static ByteBuf wrapLong(long value) {
        ByteBuf buf = ByteBufPool.allocate(20);
        int digits = ByteBufStrings.encodeLong(buf.array, 0, value);
        buf.moveTail(digits);
        return buf;
    }

    public static int decodeInt(byte[] array, int pos, int len) throws ParseException {
        int result = 0;
        int i = pos;
        int negate = 0;
        if (array[i] == 45) {
            negate = 1;
            ++i;
        }
        while (i < pos + len) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new ParseException("Not a decimal value: " + new String(array, pos, len));
            }
            if ((result = b + result * 10) < 0) {
                if (result == Integer.MIN_VALUE && i + 1 == pos + len) {
                    return Integer.MIN_VALUE;
                }
                throw new ParseException("Bigger than max int value: " + new String(array, pos, len));
            }
            ++i;
        }
        return (result ^ -negate) + negate;
    }

    public static long decodeLong(byte[] array, int pos, int len) throws ParseException {
        long result = 0L;
        int i = pos;
        int negate = 0;
        if (array[i] == 45) {
            negate = 1;
            ++i;
        }
        while (i < pos + len) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new ParseException("Not a decimal value: " + new String(array, pos, len));
            }
            if ((result = (long)b + result * 10L) < 0L) {
                if (result == Long.MIN_VALUE && i + 1 == pos + len) {
                    return Long.MIN_VALUE;
                }
                throw new ParseException("Bigger than max long value: " + new String(array, pos, len));
            }
            ++i;
        }
        return (result ^ (long)(-negate)) + (long)negate;
    }

    public static int decodePositiveInt(byte[] array, int pos, int len) throws ParseException {
        int result = 0;
        for (int i = pos; i < pos + len; ++i) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new ParseException("Not a decimal value: " + new String(array, pos, len));
            }
            if ((result = b + result * 10) >= 0) continue;
            throw new ParseException("Bigger than max int value: " + new String(array, pos, len));
        }
        return result;
    }

    public static long decodePositiveLong(byte[] array, int pos, int len) throws ParseException {
        long result = 0L;
        for (int i = pos; i < pos + len; ++i) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new ParseException("Not a decimal value: " + new String(array, pos, len));
            }
            if ((result = (long)b + result * 10L) >= 0L) continue;
            throw new ParseException("Bigger than max long value: " + new String(array, pos, len));
        }
        return result;
    }

    private static int digitsLong(long value) {
        long limit = 10L;
        for (int i = 1; i <= 18; ++i) {
            if (value < limit) {
                return i;
            }
            limit *= 10L;
        }
        return 19;
    }

    private static int digitsInt(int value) {
        int limit = 10;
        for (int i = 1; i <= 9; ++i) {
            if (value < limit) {
                return i;
            }
            limit *= 10;
        }
        return 10;
    }
}

