/*
 * Decompiled with CFR 0.152.
 */
package io.activej.bytebuf;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ByteBufConcurrentQueue {
    private final AtomicLong pos = new AtomicLong(0L);
    private final AtomicReference<AtomicReferenceArray<ByteBuf>> array = new AtomicReference(new AtomicReferenceArray(1));
    private final ConcurrentHashMap<Integer, ByteBuf> map = new ConcurrentHashMap();
    final AtomicInteger realMin = new AtomicInteger(0);

    ByteBufConcurrentQueue() {
    }

    @Nullable
    public ByteBuf poll() {
        int tail;
        int head;
        long pos2;
        long pos1;
        do {
            if ((head = (int)((pos1 = this.pos.get()) >>> 32)) == (tail = (int)pos1)) {
                return null;
            }
            ++tail;
            if (!ByteBufPool.USE_WATCHDOG) continue;
            int size = head - tail;
            this.realMin.updateAndGet(prevMin -> Math.min(prevMin, size));
        } while (!this.pos.compareAndSet(pos1, pos2 = ((long)head << 32) + ((long)tail & 0xFFFFFFFFL)));
        Integer boxedTail = null;
        while (true) {
            AtomicReferenceArray<ByteBuf> bufs;
            ByteBuf buf;
            if ((buf = (ByteBuf)(bufs = this.array.get()).getAndSet(tail & bufs.length() - 1, null)) == null) {
                if (boxedTail == null) {
                    boxedTail = tail;
                }
                if ((buf = this.map.remove(boxedTail)) == null) {
                    Thread.yield();
                    continue;
                }
            }
            if (buf.pos == tail) {
                return buf;
            }
            this.map.put(buf.pos, buf);
        }
    }

    public void offer(@NotNull ByteBuf buf) {
        int idx;
        int head;
        long pos2;
        long pos1;
        while (!this.pos.compareAndSet(pos1 = this.pos.get(), pos2 = pos1 + 0x100000000L)) {
        }
        buf.pos = head = (int)(pos2 >>> 32);
        AtomicReferenceArray<ByteBuf> bufs = this.array.get();
        ByteBuf buf2 = bufs.getAndSet(idx = head & bufs.length() - 1, buf);
        if (buf2 == null && bufs == this.array.get()) {
            return;
        }
        this.pushToMap(bufs, idx, buf2);
    }

    private void pushToMap(AtomicReferenceArray<ByteBuf> bufs, int idx, @Nullable ByteBuf buf2) {
        ByteBuf buf3 = bufs.getAndSet(idx, null);
        if (buf2 == null && buf3 == null) {
            return;
        }
        if (buf2 != null) {
            this.map.put(buf2.pos, buf2);
        }
        if (buf3 != null) {
            this.map.put(buf3.pos, buf3);
        }
        this.ensureCapacity();
    }

    private void ensureCapacity() {
        int capacityNew = 1 << 32 - Integer.numberOfLeadingZeros(this.size() * 4 - 1);
        if (this.array.get().length() >= capacityNew) {
            return;
        }
        this.resize(capacityNew);
    }

    private void resize(int capacityNew) {
        AtomicReferenceArray bufsNew = new AtomicReferenceArray(capacityNew);
        AtomicReferenceArray bufsOld = this.array.getAndSet(bufsNew);
        for (int i = 0; i < bufsOld.length(); ++i) {
            ByteBuf buf = bufsOld.getAndSet(i, null);
            if (buf == null) continue;
            this.map.put(buf.pos, buf);
        }
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.poll();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        long pos1 = this.pos.get();
        int head = (int)(pos1 >>> 32);
        int tail = (int)pos1;
        return head - tail;
    }

    public String toString() {
        return "ByteBufConcurrentStack{size=" + this.size() + ", array=" + this.array.get().length() + ", map=" + this.map.size() + '}';
    }
}

