/*
 * Decompiled with CFR 0.152.
 */
package io.activej.bytebuf;

import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.common.api.Sliceable;
import io.activej.common.recycle.Recyclable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ByteBuf
implements Recyclable,
Sliceable<ByteBuf> {
    private static final boolean CHECK = Checks.isEnabled(ByteBuf.class);
    static final boolean CHECK_RECYCLE = ByteBufPool.REGISTRY || CHECK;
    @NotNull
    protected final byte[] array;
    int head;
    int tail;
    int refs;
    volatile int pos;
    private static final ByteBuf EMPTY = ByteBuf.wrap(new byte[0], 0, 0);

    private ByteBuf(@NotNull byte[] array, int head, int tail) {
        if (CHECK) {
            Checks.checkArgument((head >= 0 && head <= tail && tail <= array.length ? 1 : 0) != 0, () -> "Wrong ByteBuf boundaries - readPos: " + head + ", writePos: " + tail + ", array.length: " + array.length);
        }
        this.array = array;
        this.head = head;
        this.tail = tail;
    }

    @Contract(pure=true)
    public static ByteBuf empty() {
        if (CHECK) {
            Checks.checkState((ByteBuf.EMPTY.head == 0 && ByteBuf.EMPTY.tail == 0 ? 1 : 0) != 0);
        }
        return EMPTY;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ByteBuf wrapForWriting(@NotNull byte[] bytes) {
        return ByteBuf.wrap(bytes, 0, 0);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ByteBuf wrapForReading(@NotNull byte[] bytes) {
        return ByteBuf.wrap(bytes, 0, bytes.length);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static ByteBuf wrap(@NotNull byte[] bytes, int head, int tail) {
        return new ByteBuf(bytes, head, tail);
    }

    @NotNull
    @Contract(value="-> new")
    public ByteBuf slice() {
        return this.slice(this.head, this.readRemaining());
    }

    @NotNull
    @Contract(value="_ -> new")
    public ByteBuf slice(int length) {
        return this.slice(this.head, length);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public ByteBuf slice(int offset, int length) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (!this.isRecycleNeeded()) {
            return ByteBuf.wrap(this.array, offset, offset + length);
        }
        ++this.refs;
        return new ByteBufSlice(this, offset, offset + length);
    }

    public void recycle() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (this.refs > 0 && --this.refs == 0) {
            if (CHECK_RECYCLE) {
                this.refs = -1;
            }
            ByteBufPool.recycle(this);
        }
    }

    public void addRef() {
        ++this.refs;
    }

    @Contract(pure=true)
    protected boolean isRecycled() {
        return this.refs < 0;
    }

    public void rewind() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.tail = 0;
        this.head = 0;
    }

    @Contract(pure=true)
    protected boolean isRecycleNeeded() {
        return this.refs > 0;
    }

    public ByteBuffer toReadByteBuffer() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return ByteBuffer.wrap(this.array, this.head, this.readRemaining());
    }

    public ByteBuffer toWriteByteBuffer() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return ByteBuffer.wrap(this.array, this.tail, this.writeRemaining());
    }

    public void ofReadByteBuffer(ByteBuffer byteBuffer) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((this.array == byteBuffer.array() && byteBuffer.limit() == this.tail ? 1 : 0) != 0);
        }
        this.head = byteBuffer.position();
    }

    public void ofWriteByteBuffer(ByteBuffer byteBuffer) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((this.array == byteBuffer.array() && byteBuffer.limit() == this.array.length ? 1 : 0) != 0);
        }
        this.tail = byteBuffer.position();
    }

    @NotNull
    @Contract(pure=true)
    public byte[] array() {
        return this.array;
    }

    @Contract(pure=true)
    public int limit() {
        return this.array.length;
    }

    @Contract(pure=true)
    public int head() {
        return this.head;
    }

    public void head(int pos) {
        if (CHECK) {
            Checks.checkArgument((pos <= this.tail ? 1 : 0) != 0);
        }
        this.head = pos;
    }

    @Contract(pure=true)
    public int tail() {
        return this.tail;
    }

    public void tail(int pos) {
        if (CHECK) {
            Checks.checkArgument((pos >= this.head && pos <= this.array.length ? 1 : 0) != 0);
        }
        this.tail = pos;
    }

    public void moveHead(int delta) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((this.head + delta >= 0 ? 1 : 0) != 0, (Object)"New head cannot be negative");
            Checks.checkArgument((this.head + delta <= this.tail ? 1 : 0) != 0, (Object)"New head cannot be greater than tail");
        }
        this.head += delta;
    }

    public void moveTail(int delta) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((this.tail + delta >= this.head ? 1 : 0) != 0, (Object)"New tail cannot be lesser than head");
            Checks.checkArgument((this.tail + delta <= this.array.length ? 1 : 0) != 0, (Object)"New tail cannot be greater than size of underlying array");
        }
        this.tail += delta;
    }

    @Contract(pure=true)
    public int readRemaining() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.tail - this.head;
    }

    @Contract(pure=true)
    public int writeRemaining() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.array.length - this.tail;
    }

    @Contract(pure=true)
    public boolean canRead() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.head != this.tail;
    }

    @Contract(pure=true)
    public boolean canWrite() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.tail != this.array.length;
    }

    public byte get() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkState((this.head < this.tail ? 1 : 0) != 0, (Object)"No bytes are remaining for read");
        }
        return this.array[this.head++];
    }

    @Contract(pure=true)
    public byte at(int index) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.array[index];
    }

    @Contract(pure=true)
    public byte peek() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.array[this.head];
    }

    @Contract(pure=true)
    public byte peek(int offset) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((this.head + offset < this.tail ? 1 : 0) != 0, (Object)"Trying to peek outside of buf's limit");
        }
        return this.array[this.head + offset];
    }

    public int drainTo(@NotNull byte[] array, int offset, int length) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((length >= 0 ? 1 : 0) != 0, () -> "Length should be a positive value");
            Checks.checkArgument((offset + length <= array.length && this.head + length <= this.tail ? 1 : 0) != 0, (Object)"Trying to drain from outside this buf's limit");
        }
        System.arraycopy(this.array, this.head, array, offset, length);
        this.head += length;
        return length;
    }

    public int drainTo(@NotNull ByteBuf buf, int length) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((buf.tail + length <= buf.array.length ? 1 : 0) != 0, (Object)"Trying to drain from outside this buf's limit");
        }
        this.drainTo(buf.array, buf.tail, length);
        buf.tail += length;
        return length;
    }

    public void set(int index, byte b) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.array[index] = b;
    }

    public void put(byte b) {
        this.set(this.tail, b);
        ++this.tail;
    }

    public void put(@NotNull ByteBuf buf) {
        this.put(buf.array, buf.head, buf.tail - buf.head);
        buf.head = buf.tail;
    }

    public void put(@NotNull byte[] bytes) {
        this.put(bytes, 0, bytes.length);
    }

    public void put(@NotNull byte[] bytes, int offset, int length) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if (CHECK) {
            Checks.checkArgument((this.tail + length <= this.array.length ? 1 : 0) != 0, () -> "This buf cannot hold " + length + " more bytes");
            Checks.checkArgument((offset + length <= bytes.length ? 1 : 0) != 0, (Object)"Not enough bytes in source array");
        }
        System.arraycopy(bytes, offset, this.array, this.tail, length);
        this.tail += length;
    }

    public int find(byte b) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        for (int i = this.head; i < this.tail; ++i) {
            if (this.array[i] != b) continue;
            return i;
        }
        return -1;
    }

    public int find(@NotNull byte[] bytes) {
        return this.find(bytes, 0, bytes.length);
    }

    public int find(@NotNull byte[] bytes, int off, int len) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        block0: for (int pos = this.head; pos <= this.tail - len; ++pos) {
            for (int i = 0; i < len; ++i) {
                if (this.array[pos + i] != bytes[off + i]) continue block0;
            }
            return pos;
        }
        return -1;
    }

    @Contract(pure=true)
    public boolean isContentEqual(@NotNull byte[] array, int offset, int length) {
        return Utils.arraysEquals((byte[])this.array, (int)this.head, (int)this.readRemaining(), (byte[])array, (int)offset, (int)length);
    }

    @Contract(pure=true)
    public boolean isContentEqual(@NotNull ByteBuf other) {
        return this.isContentEqual(other.array, other.head, other.readRemaining());
    }

    @Contract(pure=true)
    public boolean isContentEqual(byte[] array) {
        return this.isContentEqual(array, 0, array.length);
    }

    @Contract(pure=true)
    @NotNull
    public byte[] getArray() {
        byte[] bytes = new byte[this.readRemaining()];
        System.arraycopy(this.array, this.head, bytes, 0, bytes.length);
        return bytes;
    }

    @Contract(pure=false)
    @NotNull
    public byte[] asArray() {
        byte[] bytes = this.getArray();
        this.recycle();
        return bytes;
    }

    @Contract(pure=true)
    public String getString(@NotNull Charset charset) {
        return new String(this.array, this.head, this.readRemaining(), charset);
    }

    @Contract(pure=false)
    public String asString(@NotNull Charset charset) {
        String string = this.getString(charset);
        this.recycle();
        return string;
    }

    public int read(@NotNull byte[] b) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.read(b, 0, b.length);
    }

    public int read(@NotNull byte[] b, int off, int len) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.drainTo(b, off, len);
    }

    public byte readByte() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return this.array[this.head++];
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public char readChar() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        char c = (char)((this.array[this.head] & 0xFF) << 8 | this.array[this.head + 1] & 0xFF);
        this.head += 2;
        return c;
    }

    public double readDouble() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        return Float.intBitsToFloat(this.readInt());
    }

    public int readInt() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        int result = (this.array[this.head] & 0xFF) << 24 | (this.array[this.head + 1] & 0xFF) << 16 | (this.array[this.head + 2] & 0xFF) << 8 | this.array[this.head + 3] & 0xFF;
        this.head += 4;
        return result;
    }

    public int readVarInt() {
        int result;
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        int b = this.array[this.head];
        if (b >= 0) {
            result = b;
            ++this.head;
        } else {
            result = b & 0x7F;
            b = this.array[this.head + 1];
            if (b >= 0) {
                result |= b << 7;
                this.head += 2;
            } else {
                result |= (b & 0x7F) << 7;
                b = this.array[this.head + 2];
                if (b >= 0) {
                    result |= b << 14;
                    this.head += 3;
                } else {
                    result |= (b & 0x7F) << 14;
                    b = this.array[this.head + 3];
                    if (b >= 0) {
                        result |= b << 21;
                        this.head += 4;
                    } else {
                        result |= (b & 0x7F) << 21;
                        b = this.array[this.head + 4];
                        if (b >= 0) {
                            result |= b << 28;
                            this.head += 5;
                        } else {
                            throw new IllegalStateException("Read varint was too long");
                        }
                    }
                }
            }
        }
        return result;
    }

    public long readLong() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        long result = (long)this.array[this.head] << 56 | (long)(this.array[this.head + 1] & 0xFF) << 48 | (long)(this.array[this.head + 2] & 0xFF) << 40 | (long)(this.array[this.head + 3] & 0xFF) << 32 | (long)(this.array[this.head + 4] & 0xFF) << 24 | (long)((this.array[this.head + 5] & 0xFF) << 16) | (long)((this.array[this.head + 6] & 0xFF) << 8) | (long)(this.array[this.head + 7] & 0xFF);
        this.head += 8;
        return result;
    }

    public short readShort() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        short result = (short)((this.array[this.head] & 0xFF) << 8 | this.array[this.head + 1] & 0xFF);
        this.head += 2;
        return result;
    }

    public long readVarLong() {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalStateException("Read varint was too long");
    }

    public void write(@NotNull byte[] b) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.write(b, 0, b.length);
    }

    public void write(@NotNull byte[] b, int off, int len) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        System.arraycopy(b, off, this.array, this.tail, len);
        this.tail += len;
    }

    public void writeBoolean(boolean v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.writeByte(v ? (byte)1 : 0);
    }

    public void writeByte(byte v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.array[this.tail] = v;
        ++this.tail;
    }

    public void writeChar(char v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.array[this.tail] = (byte)(v >>> 8);
        this.array[this.tail + 1] = (byte)v;
        this.tail += 2;
    }

    public void writeDouble(double v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeInt(int v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.array[this.tail] = (byte)(v >>> 24);
        this.array[this.tail + 1] = (byte)(v >>> 16);
        this.array[this.tail + 2] = (byte)(v >>> 8);
        this.array[this.tail + 3] = (byte)v;
        this.tail += 4;
    }

    public void writeLong(long v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        int high = (int)(v >>> 32);
        int low = (int)v;
        this.array[this.tail] = (byte)(high >>> 24);
        this.array[this.tail + 1] = (byte)(high >>> 16);
        this.array[this.tail + 2] = (byte)(high >>> 8);
        this.array[this.tail + 3] = (byte)high;
        this.array[this.tail + 4] = (byte)(low >>> 24);
        this.array[this.tail + 5] = (byte)(low >>> 16);
        this.array[this.tail + 6] = (byte)(low >>> 8);
        this.array[this.tail + 7] = (byte)low;
        this.tail += 8;
    }

    public void writeShort(short v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        this.array[this.tail] = (byte)(v >>> 8);
        this.array[this.tail + 1] = (byte)v;
        this.tail += 2;
    }

    public void writeVarInt(int v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if ((v & 0xFFFFFF80) == 0) {
            this.array[this.tail] = (byte)v;
            ++this.tail;
            return;
        }
        this.array[this.tail] = (byte)(v | 0x80);
        if (((v >>>= 7) & 0xFFFFFF80) == 0) {
            this.array[this.tail + 1] = (byte)v;
            this.tail += 2;
            return;
        }
        this.array[this.tail + 1] = (byte)(v | 0x80);
        if (((v >>>= 7) & 0xFFFFFF80) == 0) {
            this.array[this.tail + 2] = (byte)v;
            this.tail += 3;
            return;
        }
        this.array[this.tail + 2] = (byte)(v | 0x80);
        if (((v >>>= 7) & 0xFFFFFF80) == 0) {
            this.array[this.tail + 3] = (byte)v;
            this.tail += 4;
            return;
        }
        this.array[this.tail + 3] = (byte)(v | 0x80);
        this.array[this.tail + 4] = (byte)(v >>>= 7);
        this.tail += 5;
    }

    public void writeVarLong(long v) {
        if (CHECK_RECYCLE && this.isRecycled()) {
            throw ByteBufPool.onByteBufRecycled(this);
        }
        if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.array[this.tail] = (byte)v;
            ++this.tail;
            return;
        }
        this.array[this.tail] = (byte)(v | 0x80L);
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.array[this.tail + 1] = (byte)v;
            this.tail += 2;
            return;
        }
        this.array[this.tail + 1] = (byte)(v | 0x80L);
        v >>>= 7;
        this.tail += 2;
        while (true) {
            if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeByte((byte)v);
                return;
            }
            this.writeByte((byte)(v | 0x80L));
            v >>>= 7;
        }
    }

    @Contract(pure=true)
    public String toString() {
        char[] chars = new char[Math.min(this.tail - this.head, 256)];
        for (int i = 0; i < chars.length; ++i) {
            byte b = this.array[this.head + i];
            chars[i] = b == 10 ? 9166 : (b >= 32 ? (int)b : 65533);
        }
        return new String(chars);
    }

    static final class ByteBufSlice
    extends ByteBuf {
        @NotNull
        private final ByteBuf root;

        private ByteBufSlice(@NotNull ByteBuf buf, int head, int tail) {
            super(buf.array, head, tail);
            this.root = buf;
        }

        @Override
        public void recycle() {
            this.root.recycle();
        }

        @Override
        public void addRef() {
            this.root.addRef();
        }

        @Override
        @NotNull
        public ByteBuf slice(int offset, int length) {
            return this.root.slice(offset, length);
        }

        @Override
        @Contract(pure=true)
        protected boolean isRecycled() {
            return this.root.isRecycled();
        }

        @Override
        @Contract(pure=true)
        protected boolean isRecycleNeeded() {
            return this.root.isRecycleNeeded();
        }
    }
}

