/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation.util;

import io.activej.aggregation.Aggregate;
import io.activej.aggregation.PrimaryKey;
import io.activej.aggregation.annotation.Key;
import io.activej.aggregation.annotation.Measures;
import io.activej.aggregation.fieldtype.FieldType;
import io.activej.aggregation.measure.Measure;
import io.activej.aggregation.ot.AggregationStructure;
import io.activej.aggregation.util.PartitionPredicate;
import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredCodecs;
import io.activej.codegen.ClassBuilder;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.common.Checks;
import io.activej.common.collection.CollectionUtils;
import io.activej.common.reflection.ReflectionUtils;
import io.activej.datastream.processor.StreamReducers;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.SerializerBuilder;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefClass;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Utils {
    private static final PartitionPredicate SINGLE_PARTITION = (t, u) -> true;

    public static <K extends Comparable> Class<K> createKeyClass(Map<String, FieldType> keys, DefiningClassLoader classLoader) {
        ArrayList<String> keyList = new ArrayList<String>(keys.keySet());
        return ((ClassBuilder)ClassBuilder.create((DefiningClassLoader)classLoader, Comparable.class, (Class[])new Class[0]).withClassKey(new Object[]{keyList}).withInitializer(cb -> keys.forEach((key, value) -> cb.withField(key, value.getInternalDataType())))).withMethod("compareTo", Expressions.compareToImpl(keyList)).withMethod("equals", Expressions.equalsImpl(keyList)).withMethod("hashCode", Expressions.hashCodeImpl(keyList)).withMethod("toString", Expressions.toStringImpl(keyList)).build();
    }

    public static <R> Comparator<R> createKeyComparator(Class<R> recordClass, List<String> keys, DefiningClassLoader classLoader) {
        return (Comparator)ClassBuilder.create((DefiningClassLoader)classLoader, Comparator.class, (Class[])new Class[0]).withClassKey(new Object[]{recordClass, keys}).withMethod("compare", Expressions.compare(recordClass, keys)).buildClassAndCreateNewInstance();
    }

    public static <T, R> Function<T, R> createMapper(Class<T> recordClass, Class<R> resultClass, List<String> keys, List<String> fields, DefiningClassLoader classLoader) {
        return (Function)ClassBuilder.create((DefiningClassLoader)classLoader, Function.class, (Class[])new Class[0]).withClassKey(new Object[]{recordClass, resultClass, keys, fields}).withMethod("apply", Expressions.let((Expression)Expressions.constructor(resultClass, (Expression[])new Expression[0]), result -> Expressions.sequence(expressions -> {
            for (String fieldName : CollectionUtils.concat((Collection)keys, (Collection)fields)) {
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)result, (String)fieldName), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)fieldName)));
            }
            expressions.add(result);
        }))).buildClassAndCreateNewInstance();
    }

    public static <K extends Comparable, R> Function<R, K> createKeyFunction(Class<R> recordClass, Class<K> keyClass, List<String> keys, DefiningClassLoader classLoader) {
        return (Function)ClassBuilder.create((DefiningClassLoader)classLoader, Function.class, (Class[])new Class[0]).withClassKey(new Object[]{recordClass, keyClass, keys}).withMethod("apply", Expressions.let((Expression)Expressions.constructor(keyClass, (Expression[])new Expression[0]), key -> Expressions.sequence(expressions -> {
            for (String keyString : keys) {
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)key, (String)keyString), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)keyString)));
            }
            expressions.add(key);
        }))).buildClassAndCreateNewInstance();
    }

    public static <T> Class<T> createRecordClass(AggregationStructure aggregation, Collection<String> keys, Collection<String> fields, DefiningClassLoader classLoader) {
        return Utils.createRecordClass(CollectionUtils.keysToMap(keys.stream(), aggregation.getKeyTypes()::get), CollectionUtils.keysToMap(fields.stream(), aggregation.getMeasureTypes()::get), classLoader);
    }

    public static <T> Class<T> createRecordClass(Map<String, FieldType> keys, Map<String, FieldType> fields, DefiningClassLoader classLoader) {
        ArrayList<String> keysList = new ArrayList<String>(keys.keySet());
        ArrayList<String> fieldsList = new ArrayList<String>(fields.keySet());
        return ((ClassBuilder)((ClassBuilder)ClassBuilder.create((DefiningClassLoader)classLoader, Object.class, (Class[])new Class[0]).withClassKey(new Object[]{keysList, fieldsList}).withInitializer(cb -> keys.forEach((key, value) -> cb.withField(key, value.getInternalDataType())))).withInitializer(cb -> fields.forEach((key, value) -> cb.withField(key, value.getInternalDataType())))).withMethod("toString", Expressions.toStringImpl((List)CollectionUtils.concat(keys.keySet(), fields.keySet()))).build();
    }

    public static <T> BinarySerializer<T> createBinarySerializer(AggregationStructure aggregation, Class<T> recordClass, List<String> keys, List<String> fields, DefiningClassLoader classLoader) {
        return Utils.createBinarySerializer(recordClass, CollectionUtils.keysToMap(keys.stream(), aggregation.getKeyTypes()::get), CollectionUtils.keysToMap(fields.stream(), aggregation.getMeasureTypes()::get), classLoader);
    }

    private static <T> BinarySerializer<T> createBinarySerializer(Class<T> recordClass, Map<String, FieldType> keys, Map<String, FieldType> fields, DefiningClassLoader classLoader) {
        SerializerDefClass serializer = SerializerDefClass.of(recordClass);
        Utils.addFields(recordClass, new ArrayList<Map.Entry<String, FieldType>>(keys.entrySet()), serializer);
        Utils.addFields(recordClass, new ArrayList<Map.Entry<String, FieldType>>(fields.entrySet()), serializer);
        ArrayList<String> keysList = new ArrayList<String>(keys.keySet());
        ArrayList<String> fieldsList = new ArrayList<String>(fields.keySet());
        return SerializerBuilder.create((DefiningClassLoader)classLoader).withClassKey(new Object[]{recordClass, keysList, fieldsList}).build((SerializerDef)serializer);
    }

    private static <T> void addFields(Class<T> recordClass, List<Map.Entry<String, FieldType>> fields, SerializerDefClass serializer) {
        for (Map.Entry<String, FieldType> entry : fields) {
            try {
                Field field = recordClass.getField(entry.getKey());
                serializer.addField(field, entry.getValue().getSerializer(), -1, -1);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <K extends Comparable, I, O, A> StreamReducers.Reducer<K, I, O, A> aggregationReducer(AggregationStructure aggregation, Class<I> inputClass, Class<O> outputClass, List<String> keys, List<String> fields, DefiningClassLoader classLoader) {
        return (StreamReducers.Reducer)ClassBuilder.create((DefiningClassLoader)classLoader, StreamReducers.Reducer.class, (Class[])new Class[0]).withClassKey(new Object[]{inputClass, outputClass, keys, fields}).withMethod("onFirstItem", Expressions.let((Expression)Expressions.constructor(outputClass, (Expression[])new Expression[0]), accumulator -> Expressions.sequence(expressions -> {
            for (String key : keys) {
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)accumulator, (String)key), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)2), (Class)inputClass), (String)key)));
            }
            for (String field : fields) {
                expressions.add(aggregation.getMeasure(field).initAccumulatorWithAccumulator(Expressions.property((Expression)accumulator, (String)field), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)2), (Class)inputClass), (String)field)));
            }
            expressions.add(accumulator);
        }))).withMethod("onNextItem", Expressions.sequence(expressions -> {
            for (String field : fields) {
                expressions.add(aggregation.getMeasure(field).reduce(Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)3), (Class)outputClass), (String)field), Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)2), (Class)inputClass), (String)field)));
            }
            expressions.add(Expressions.arg((int)3));
        })).withMethod("onComplete", Expressions.call((Expression)Expressions.arg((int)0), (String)"accept", (Expression[])new Expression[]{Expressions.arg((int)2)})).buildClassAndCreateNewInstance();
    }

    public static <I, O> Aggregate<O, Object> createPreaggregator(AggregationStructure aggregation, Class<I> inputClass, Class<O> outputClass, Map<String, String> keyFields, Map<String, String> measureFields, DefiningClassLoader classLoader) {
        ArrayList<String> keysList = new ArrayList<String>(keyFields.keySet());
        ArrayList<String> measuresList = new ArrayList<String>(measureFields.keySet());
        return (Aggregate)ClassBuilder.create((DefiningClassLoader)classLoader, Aggregate.class, (Class[])new Class[0]).withClassKey(new Object[]{inputClass, outputClass, keysList, measuresList}).withMethod("createAccumulator", Expressions.let((Expression)Expressions.constructor(outputClass, (Expression[])new Expression[0]), accumulator -> Expressions.sequence(expressions -> {
            for (Map.Entry entry : keyFields.entrySet()) {
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)accumulator, (String)((String)entry.getKey())), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)inputClass), (String)((String)entry.getValue()))));
            }
            for (Map.Entry entry : measureFields.entrySet()) {
                String measure = (String)entry.getKey();
                String inputFields = (String)entry.getValue();
                Measure aggregateFunction = aggregation.getMeasure(measure);
                expressions.add(aggregateFunction.initAccumulatorWithValue(Expressions.property((Expression)accumulator, (String)measure), inputFields == null ? null : Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)inputClass), (String)inputFields)));
            }
            expressions.add(accumulator);
        }))).withMethod("accumulate", Expressions.sequence(expressions -> {
            for (Map.Entry entry : measureFields.entrySet()) {
                String measure = (String)entry.getKey();
                String inputFields = (String)entry.getValue();
                Measure aggregateFunction = aggregation.getMeasure(measure);
                expressions.add(aggregateFunction.accumulate(Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)outputClass), (String)measure), inputFields == null ? null : Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)1), (Class)inputClass), (String)inputFields)));
            }
        })).buildClassAndCreateNewInstance();
    }

    public static <T> PartitionPredicate<T> singlePartition() {
        return SINGLE_PARTITION;
    }

    public static PartitionPredicate createPartitionPredicate(Class recordClass, List<String> partitioningKey, DefiningClassLoader classLoader) {
        if (partitioningKey.isEmpty()) {
            return Utils.singlePartition();
        }
        return (PartitionPredicate)ClassBuilder.create((DefiningClassLoader)classLoader, PartitionPredicate.class, (Class[])new Class[0]).withClassKey(new Object[]{recordClass, partitioningKey}).withMethod("isSamePartition", Expressions.and(partitioningKey.stream().map(keyComponent -> Expressions.cmpEq((Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)keyComponent), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)1), (Class)recordClass), (String)keyComponent))))).buildClassAndCreateNewInstance();
    }

    public static <T> Map<String, String> scanKeyFields(Class<T> inputClass) {
        String value;
        Key annotation;
        LinkedHashMap<String, String> keyFields = new LinkedHashMap<String, String>();
        for (Field field : inputClass.getFields()) {
            annotation = field.getAnnotation(Key.class);
            if (annotation == null) continue;
            value = annotation.value();
            keyFields.put("".equals(value) ? field.getName() : value, field.getName());
        }
        for (AccessibleObject accessibleObject : inputClass.getMethods()) {
            annotation = ((Method)accessibleObject).getAnnotation(Key.class);
            if (annotation == null) continue;
            value = annotation.value();
            keyFields.put("".equals(value) ? ((Method)accessibleObject).getName() : value, ((Method)accessibleObject).getName());
        }
        Checks.checkArgument((!keyFields.isEmpty() ? 1 : 0) != 0, (String)"Missing @Key annotations in %s", (Object[])new Object[]{inputClass});
        return keyFields;
    }

    public static <T> Map<String, String> scanMeasureFields(Class<T> inputClass) {
        LinkedHashMap<String, String> measureFields = new LinkedHashMap<String, String>();
        Measures annotation = inputClass.getAnnotation(Measures.class);
        if (annotation != null) {
            for (String measure : annotation.value()) {
                measureFields.put(measure, null);
            }
        }
        for (Field field : inputClass.getFields()) {
            annotation = field.getAnnotation(Measures.class);
            if (annotation == null) continue;
            for (String measure : annotation.value()) {
                measureFields.put(measure.equals("") ? field.getName() : measure, field.getName());
            }
        }
        for (Method method : inputClass.getMethods()) {
            annotation = method.getAnnotation(Measures.class);
            if (annotation == null) continue;
            for (String measure : annotation.value()) {
                measureFields.put(measure.equals("") ? ReflectionUtils.extractFieldNameFromGetter((Method)method) : measure, method.getName());
            }
        }
        Checks.checkArgument((!measureFields.isEmpty() ? 1 : 0) != 0, (String)"Missing @Measure(s) annotations in %s", (Object[])new Object[]{inputClass});
        return measureFields;
    }

    public static StructuredCodec<PrimaryKey> getPrimaryKeyCodec(AggregationStructure aggregation) {
        StructuredCodec[] keyCodec = new StructuredCodec[aggregation.getKeys().size()];
        for (int i = 0; i < aggregation.getKeys().size(); ++i) {
            String key = aggregation.getKeys().get(i);
            FieldType keyType = aggregation.getKeyTypes().get(key);
            keyCodec[i] = keyType.getInternalCodec();
        }
        return StructuredCodecs.ofTupleArray((StructuredCodec[])keyCodec).transform(PrimaryKey::ofArray, PrimaryKey::getArray);
    }
}

