/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation.measure;

import io.activej.aggregation.fieldtype.FieldType;
import io.activej.aggregation.measure.HyperLogLog;
import io.activej.aggregation.measure.Measure;
import io.activej.codec.StructuredCodecs;
import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.Utils;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefArray;
import io.activej.serializer.impl.SerializerDefByte;
import io.activej.serializer.impl.SerializerDefClass;
import java.util.Collections;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public final class MeasureHyperLogLog
extends Measure {
    private final int registers;

    MeasureHyperLogLog(int registers) {
        super(new FieldTypeHyperLogLog());
        this.registers = registers;
    }

    public static MeasureHyperLogLog create(int registers) {
        return new MeasureHyperLogLog(registers);
    }

    @Override
    public Expression valueOfAccumulator(Expression accumulator) {
        return Expressions.call((Expression)accumulator, (String)"estimate", (Expression[])new Expression[0]);
    }

    @Override
    public Expression zeroAccumulator(Variable accumulator) {
        return Expressions.set((StoreDef)accumulator, (Expression)Expressions.constructor(HyperLogLog.class, (Expression[])new Expression[]{Expressions.value((Object)this.registers)}));
    }

    @Override
    public Expression initAccumulatorWithAccumulator(Variable accumulator, Expression firstAccumulator) {
        return Expressions.sequence((Expression[])new Expression[]{Expressions.set((StoreDef)accumulator, (Expression)Expressions.constructor(HyperLogLog.class, (Expression[])new Expression[]{Expressions.value((Object)this.registers)})), Expressions.call((Expression)accumulator, (String)"union", (Expression[])new Expression[]{firstAccumulator})});
    }

    @Override
    public Expression reduce(Variable accumulator, Variable nextAccumulator) {
        return Expressions.call((Expression)accumulator, (String)"union", (Expression[])new Expression[]{nextAccumulator});
    }

    @Override
    public Expression initAccumulatorWithValue(Variable accumulator, Variable firstValue) {
        return Expressions.sequence((Expression[])new Expression[]{Expressions.set((StoreDef)accumulator, (Expression)Expressions.constructor(HyperLogLog.class, (Expression[])new Expression[]{Expressions.value((Object)this.registers)})), MeasureHyperLogLog.add((Expression)accumulator, (Expression)firstValue)});
    }

    @Override
    public Expression accumulate(Variable accumulator, Variable nextValue) {
        return MeasureHyperLogLog.add((Expression)accumulator, (Expression)nextValue);
    }

    private static Expression add(Expression accumulator, Expression value) {
        return new ExpressionHyperLogLog(value, accumulator);
    }

    private static final class FieldTypeHyperLogLog
    extends FieldType<Integer> {
        public FieldTypeHyperLogLog() {
            super(HyperLogLog.class, Integer.TYPE, FieldTypeHyperLogLog.serializerDef(), StructuredCodecs.INT_CODEC, null);
        }

        private static SerializerDef serializerDef() {
            SerializerDefClass serializer = SerializerDefClass.of(HyperLogLog.class);
            try {
                serializer.addGetter(HyperLogLog.class.getMethod("getRegisters", new Class[0]), (SerializerDef)new SerializerDefArray((SerializerDef)new SerializerDefByte(false), byte[].class), -1, -1);
                serializer.setConstructor(HyperLogLog.class.getConstructor(byte[].class), Collections.singletonList("registers"));
            }
            catch (NoSuchMethodException ignored) {
                throw new RuntimeException("Unable to construct SerializerDef for HyperLogLog");
            }
            return serializer;
        }
    }

    private static class ExpressionHyperLogLog
    implements Expression {
        private final Expression value;
        private final Expression accumulator;

        public ExpressionHyperLogLog(Expression value, Expression accumulator) {
            this.value = value;
            this.accumulator = accumulator;
        }

        public Type load(Context ctx) {
            Type methodParameterType;
            String methodName;
            GeneratorAdapter g = ctx.getGeneratorAdapter();
            Type accumulatorType = this.accumulator.load(ctx);
            Type valueType = this.value.load(ctx);
            if (valueType == Type.LONG_TYPE || valueType.getClassName().equals(Long.class.getName())) {
                methodName = "addLong";
                methodParameterType = Type.LONG_TYPE;
            } else if (valueType == Type.INT_TYPE || valueType.getClassName().equals(Integer.class.getName())) {
                methodName = "addInt";
                methodParameterType = Type.INT_TYPE;
            } else {
                methodName = "addObject";
                methodParameterType = Type.getType(Object.class);
            }
            if (Utils.isWrapperType((Type)valueType)) {
                g.unbox(methodParameterType);
            }
            ctx.invoke(accumulatorType, methodName, new Type[]{methodParameterType});
            return Type.VOID_TYPE;
        }
    }
}

