/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation.fieldtype;

import io.activej.aggregation.fieldtype.FieldType;
import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredCodecs;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.util.Primitives;
import io.activej.common.exception.parse.ParseException;
import io.activej.common.reflection.RecursiveType;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.StringFormat;
import io.activej.serializer.impl.SerializerDefByte;
import io.activej.serializer.impl.SerializerDefDouble;
import io.activej.serializer.impl.SerializerDefEnum;
import io.activej.serializer.impl.SerializerDefFloat;
import io.activej.serializer.impl.SerializerDefInt;
import io.activej.serializer.impl.SerializerDefLong;
import io.activej.serializer.impl.SerializerDefPrimitive;
import io.activej.serializer.impl.SerializerDefSet;
import io.activej.serializer.impl.SerializerDefShort;
import io.activej.serializer.impl.SerializerDefString;
import java.lang.reflect.Type;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Set;

public final class FieldTypes {
    public static final StructuredCodec<LocalDate> LOCAL_DATE_CODEC = new StructuredCodec<LocalDate>(){

        public void encode(StructuredOutput out, LocalDate value) {
            out.writeString(value.toString());
        }

        public LocalDate decode(StructuredInput in) throws ParseException {
            try {
                return LocalDate.parse(in.readString());
            }
            catch (DateTimeException e) {
                throw new ParseException((Throwable)e);
            }
        }
    };

    public static FieldType<Byte> ofByte() {
        return new FieldType<Byte>(Byte.TYPE, (SerializerDef)new SerializerDefByte(false), StructuredCodecs.BYTE_CODEC);
    }

    public static FieldType<Short> ofShort() {
        return new FieldType<Short>(Short.TYPE, (SerializerDef)new SerializerDefShort(false), StructuredCodecs.SHORT_CODEC);
    }

    public static FieldType<Integer> ofInt() {
        return new FieldType<Integer>(Integer.TYPE, (SerializerDef)new SerializerDefInt(false, true), StructuredCodecs.INT_CODEC);
    }

    public static FieldType<Long> ofLong() {
        return new FieldType<Long>(Long.TYPE, (SerializerDef)new SerializerDefLong(false, true), StructuredCodecs.LONG_CODEC);
    }

    public static FieldType<Float> ofFloat() {
        return new FieldType<Float>(Float.TYPE, (SerializerDef)new SerializerDefFloat(false), StructuredCodecs.FLOAT_CODEC);
    }

    public static FieldType<Double> ofDouble() {
        return new FieldType<Double>(Double.TYPE, (SerializerDef)new SerializerDefDouble(false), StructuredCodecs.DOUBLE_CODEC);
    }

    public static <T> FieldType<Set<T>> ofSet(FieldType<T> fieldType) {
        SerializerDef itemSerializer = fieldType.getSerializer();
        if (itemSerializer instanceof SerializerDefPrimitive) {
            itemSerializer = ((SerializerDefPrimitive)itemSerializer).ensureWrapped();
        }
        SerializerDefSet serializer = new SerializerDefSet(itemSerializer);
        Type wrappedNestedType = fieldType.getDataType() instanceof Class ? Primitives.wrap((Class)((Class)fieldType.getDataType())) : fieldType.getDataType();
        Type dataType = RecursiveType.of(Set.class, (RecursiveType[])new RecursiveType[]{RecursiveType.of((Type)wrappedNestedType)}).getType();
        StructuredCodec codec = StructuredCodecs.ofSet(fieldType.getCodec());
        return new FieldType<Set<T>>(Set.class, dataType, (SerializerDef)serializer, codec, codec);
    }

    public static <E extends Enum<E>> FieldType<E> ofEnum(Class<E> enumClass) {
        return new FieldType<E>(enumClass, (SerializerDef)new SerializerDefEnum(enumClass), StructuredCodecs.ofEnum(enumClass));
    }

    public static FieldType<String> ofString() {
        return new FieldType<String>(String.class, (SerializerDef)new SerializerDefString(), StructuredCodecs.STRING_CODEC);
    }

    public static FieldType<String> ofString(StringFormat format) {
        return new FieldType<String>(String.class, (SerializerDef)new SerializerDefString(format), StructuredCodecs.STRING_CODEC);
    }

    public static FieldType<LocalDate> ofLocalDate() {
        return new FieldTypeDate();
    }

    public static FieldType<LocalDate> ofLocalDate(LocalDate startDate) {
        return new FieldTypeDate(startDate);
    }

    private static final class FieldTypeDate
    extends FieldType<LocalDate> {
        private final LocalDate startDate;

        FieldTypeDate() {
            this(LocalDate.parse("1970-01-01"));
        }

        FieldTypeDate(LocalDate startDate) {
            super(Integer.TYPE, (Type)((Object)LocalDate.class), (SerializerDef)new SerializerDefInt(false, true), LOCAL_DATE_CODEC, (StructuredCodec<?>)StructuredCodecs.INT_CODEC);
            this.startDate = startDate;
        }

        @Override
        public Expression toValue(Expression internalValue) {
            return Expressions.call((Expression)Expressions.value((Object)this.startDate), (String)"plusDays", (Expression[])new Expression[]{Expressions.cast((Expression)internalValue, Long.TYPE)});
        }

        @Override
        public Object toInternalValue(LocalDate value) {
            return (int)ChronoUnit.DAYS.between(this.startDate, value);
        }
    }
}

