/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class RangeTree<K, V> {
    private final TreeMap<K, Segment<V>> segments;

    public SortedMap<K, Segment<V>> getSegments() {
        return Collections.unmodifiableSortedMap(this.segments);
    }

    private RangeTree(TreeMap<K, Segment<V>> segments) {
        this.segments = segments;
    }

    public static <K extends Comparable<K>, V> RangeTree<K, V> create() {
        return new RangeTree(new TreeMap());
    }

    public static <K extends Comparable<K>, V> RangeTree<K, V> cloneOf(RangeTree<K, V> source) {
        RangeTree<K, V> result = RangeTree.create();
        result.segments.putAll(source.segments);
        for (Map.Entry<K, Segment<Segment>> entry : result.segments.entrySet()) {
            entry.setValue(Segment.cloneOf((Segment)entry.getValue()));
        }
        return result;
    }

    private Segment<V> ensureSegment(K key) {
        return this.segments.computeIfAbsent(key, $ -> {
            Map.Entry<Object, Segment<V>> prevEntry = this.segments.lowerEntry(key);
            Segment segment = new Segment();
            if (prevEntry != null) {
                segment.set.addAll(((Segment)prevEntry.getValue()).set);
            }
            return segment;
        });
    }

    public void put(K lower, K upper, V value) {
        this.ensureSegment(lower);
        ((Segment)this.ensureSegment(upper)).closing.add(value);
        SortedMap<K, Segment<V>> subMap = this.segments.subMap(lower, upper);
        for (Map.Entry<K, Segment<V>> entry : subMap.entrySet()) {
            ((Segment)entry.getValue()).set.add(value);
        }
    }

    public boolean remove(K lower, K upper, V value) {
        boolean removed = false;
        this.ensureSegment(lower);
        removed |= ((Segment)this.ensureSegment(upper)).closing.remove(value);
        Map.Entry<K, Segment<V>> prevEntry = this.segments.lowerEntry(lower);
        Segment prev = prevEntry != null ? prevEntry.getValue() : null;
        Iterator it = this.segments.subMap(lower, true, upper, true).values().iterator();
        while (it.hasNext()) {
            Segment segment = (Segment)it.next();
            removed |= segment.set.remove(value);
            if (segment.closing.isEmpty() && segment.set.equals(prev != null ? prev.set : Collections.emptySet())) {
                it.remove();
                continue;
            }
            prev = segment;
        }
        return removed;
    }

    public Set<V> get(K key) {
        LinkedHashSet result = new LinkedHashSet();
        for (Map.Entry entry : this.segments.headMap(key, true).descendingMap().entrySet()) {
            result.addAll(((Segment)entry.getValue()).set);
            if (!entry.getKey().equals(key)) break;
            result.addAll(((Segment)entry.getValue()).closing);
        }
        return result;
    }

    public Set<V> getRange(K lower, K upper) {
        LinkedHashSet result = new LinkedHashSet();
        Map.Entry<K, Segment<V>> floorEntry = this.segments.floorEntry(lower);
        if (floorEntry != null) {
            result.addAll(((Segment)floorEntry.getValue()).set);
        }
        NavigableMap<K, Segment<V>> subMap = this.segments.subMap(lower, true, upper, true);
        for (Map.Entry entry : subMap.entrySet()) {
            result.addAll(((Segment)entry.getValue()).set);
            result.addAll(((Segment)entry.getValue()).closing);
        }
        return result;
    }

    public Set<V> getAll() {
        LinkedHashSet result = new LinkedHashSet();
        for (Segment<V> segment : this.segments.values()) {
            result.addAll(((Segment)segment).closing);
        }
        return result;
    }

    public static final class Segment<V> {
        private final LinkedHashSet<V> set = new LinkedHashSet();
        private final LinkedHashSet<V> closing = new LinkedHashSet();

        public Set<V> getSet() {
            return Collections.unmodifiableSet(this.set);
        }

        public Set<V> getClosingSet() {
            return Collections.unmodifiableSet(this.closing);
        }

        private static <V> Segment<V> cloneOf(Segment<V> segment) {
            Segment<V> result = new Segment<V>();
            result.set.addAll(segment.set);
            result.closing.addAll(segment.closing);
            return result;
        }

        public String toString() {
            return this.set + "; " + this.closing;
        }
    }
}

