/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.aggregation.AggregationChunk;
import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.AggregationPredicates;
import io.activej.aggregation.PrimaryKey;
import io.activej.aggregation.RangeTree;
import io.activej.aggregation.ot.AggregationDiff;
import io.activej.aggregation.ot.AggregationStructure;
import io.activej.common.Checks;
import io.activej.common.collection.CollectionUtils;
import io.activej.ot.OTState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregationState
implements OTState<AggregationDiff> {
    private static final Logger logger = LoggerFactory.getLogger(AggregationState.class);
    private final AggregationStructure aggregation;
    private final Map<Object, AggregationChunk> chunks = new LinkedHashMap<Object, AggregationChunk>();
    private RangeTree<PrimaryKey, AggregationChunk>[] prefixRanges;
    private static final Comparator<AggregationChunk> MIN_KEY_ASCENDING_COMPARATOR = Comparator.comparing(AggregationChunk::getMinPrimaryKey);

    AggregationState(AggregationStructure aggregation) {
        this.aggregation = aggregation;
        this.initIndex();
    }

    public Map<Object, AggregationChunk> getChunks() {
        return Collections.unmodifiableMap(this.chunks);
    }

    public void apply(AggregationDiff commit) {
        Checks.checkArgument((Object)CollectionUtils.intersection(commit.getAddedChunks(), commit.getRemovedChunks()), Set::isEmpty, v -> "Non-empty intersection between added and removed chunks: " + v + "\n Added chunks " + CollectionUtils.toLimitedString(commit.getAddedChunks(), (int)100) + "\n Removed chunks intersection: " + CollectionUtils.toLimitedString(commit.getRemovedChunks(), (int)100));
        for (AggregationChunk chunk : commit.getAddedChunks()) {
            this.addToIndex(chunk);
        }
        for (AggregationChunk chunk : commit.getRemovedChunks()) {
            this.removeFromIndex(chunk);
        }
    }

    public void addToIndex(AggregationChunk chunk) {
        Checks.checkArgument((this.chunks.put(chunk.getChunkId(), chunk) == null ? 1 : 0) != 0, () -> "Trying to add existing chunk: " + chunk + "\n this: " + this.toString() + "\n chunks: " + CollectionUtils.toLimitedString(this.chunks.keySet(), (int)100));
        for (int size = 0; size <= this.aggregation.getKeys().size(); ++size) {
            RangeTree<PrimaryKey, AggregationChunk> index = this.prefixRanges[size];
            PrimaryKey lower = chunk.getMinPrimaryKey().prefix(size);
            PrimaryKey upper = chunk.getMaxPrimaryKey().prefix(size);
            index.put(lower, upper, chunk);
        }
    }

    public void removeFromIndex(AggregationChunk chunk) {
        Checks.checkArgument((this.chunks.remove(chunk.getChunkId()) != null ? 1 : 0) != 0, () -> "Trying to remove unknown chunk: " + chunk + "\n this: " + this.toString() + "\n chunks: " + CollectionUtils.toLimitedString(this.chunks.keySet(), (int)100));
        for (int size = 0; size <= this.aggregation.getKeys().size(); ++size) {
            RangeTree<PrimaryKey, AggregationChunk> index = this.prefixRanges[size];
            PrimaryKey lower = chunk.getMinPrimaryKey().prefix(size);
            PrimaryKey upper = chunk.getMaxPrimaryKey().prefix(size);
            index.remove(lower, upper, chunk);
        }
    }

    void initIndex() {
        this.prefixRanges = new RangeTree[this.aggregation.getKeys().size() + 1];
        for (int size = 0; size <= this.aggregation.getKeys().size(); ++size) {
            this.prefixRanges[size] = RangeTree.create();
        }
    }

    public void init() {
        this.initIndex();
        this.chunks.clear();
    }

    private static int getNumberOfOverlaps(RangeTree.Segment<?> segment) {
        return segment.getSet().size() + segment.getClosingSet().size();
    }

    public Set<AggregationChunk> findOverlappingChunks() {
        int minOverlaps = 2;
        HashSet<AggregationChunk> result = new HashSet<AggregationChunk>();
        RangeTree<PrimaryKey, AggregationChunk> tree = this.prefixRanges[this.aggregation.getKeys().size()];
        for (Map.Entry<PrimaryKey, RangeTree.Segment<AggregationChunk>> segmentEntry : tree.getSegments().entrySet()) {
            RangeTree.Segment<AggregationChunk> segment = segmentEntry.getValue();
            int overlaps = AggregationState.getNumberOfOverlaps(segment);
            if (overlaps < minOverlaps) continue;
            result.addAll(segment.getSet());
            result.addAll(segment.getClosingSet());
        }
        return result;
    }

    public List<AggregationChunk> findChunksGroupWithMostOverlaps() {
        return AggregationState.findChunksGroupWithMostOverlaps(this.prefixRanges[this.aggregation.getKeys().size()]);
    }

    private static List<AggregationChunk> findChunksGroupWithMostOverlaps(RangeTree<PrimaryKey, AggregationChunk> tree) {
        int maxOverlaps = 2;
        ArrayList<AggregationChunk> result = new ArrayList<AggregationChunk>();
        for (Map.Entry<PrimaryKey, RangeTree.Segment<AggregationChunk>> segmentEntry : tree.getSegments().entrySet()) {
            RangeTree.Segment<AggregationChunk> segment = segmentEntry.getValue();
            int overlaps = AggregationState.getNumberOfOverlaps(segment);
            if (overlaps < maxOverlaps) continue;
            maxOverlaps = overlaps;
            result.clear();
            result.addAll(segment.getSet());
            result.addAll(segment.getClosingSet());
        }
        return result;
    }

    private static PickedChunks findChunksWithMinKeyOrSizeFixStrategy(SortedMap<PrimaryKey, RangeTree<PrimaryKey, AggregationChunk>> partitioningKeyToTree, int maxChunks, int optimalChunkSize) {
        int minChunks = 2;
        for (Map.Entry<PrimaryKey, RangeTree<PrimaryKey, AggregationChunk>> entry : partitioningKeyToTree.entrySet()) {
            ChunksAndStrategy chunksAndStrategy = AggregationState.findChunksWithMinKeyOrSizeFixStrategy(entry.getValue(), maxChunks, optimalChunkSize);
            if (chunksAndStrategy.chunks.size() < minChunks) continue;
            return new PickedChunks(chunksAndStrategy.strategy, entry.getValue(), chunksAndStrategy.chunks);
        }
        return new PickedChunks(PickingStrategy.MIN_KEY, null, Collections.emptyList());
    }

    private static ChunksAndStrategy findChunksWithMinKeyOrSizeFixStrategy(RangeTree<PrimaryKey, AggregationChunk> tree, int maxChunks, int optimalChunkSize) {
        int minOverlaps = 2;
        ArrayList<AggregationChunk> result = new ArrayList<AggregationChunk>();
        SortedMap<PrimaryKey, RangeTree.Segment<AggregationChunk>> tailMap = null;
        for (Map.Entry<PrimaryKey, RangeTree.Segment<AggregationChunk>> segmentEntry : tree.getSegments().entrySet()) {
            RangeTree.Segment<AggregationChunk> segment = segmentEntry.getValue();
            int overlaps = AggregationState.getNumberOfOverlaps(segment);
            if (overlaps >= minOverlaps) {
                result.addAll(segment.getSet());
                result.addAll(segment.getClosingSet());
                return new ChunksAndStrategy(PickingStrategy.MIN_KEY, result);
            }
            ArrayList<AggregationChunk> segmentChunks = new ArrayList<AggregationChunk>();
            segmentChunks.addAll(segment.getSet());
            segmentChunks.addAll(segment.getClosingSet());
            if (overlaps != 1 || ((AggregationChunk)segmentChunks.get(0)).getCount() == optimalChunkSize) continue;
            tailMap = tree.getSegments().tailMap(segmentEntry.getKey());
            break;
        }
        if (tailMap == null) {
            return new ChunksAndStrategy(PickingStrategy.SIZE_FIX, Collections.emptyList());
        }
        HashSet chunks = new HashSet();
        for (Map.Entry segmentEntry : tailMap.entrySet()) {
            if (chunks.size() >= maxChunks) break;
            RangeTree.Segment segment = (RangeTree.Segment)segmentEntry.getValue();
            chunks.addAll(segment.getSet());
            chunks.addAll(segment.getClosingSet());
        }
        result.addAll(chunks);
        if (result.size() == 1) {
            if (((AggregationChunk)result.get(0)).getCount() > optimalChunkSize) {
                return new ChunksAndStrategy(PickingStrategy.SIZE_FIX, result);
            }
            return new ChunksAndStrategy(PickingStrategy.SIZE_FIX, Collections.emptyList());
        }
        return new ChunksAndStrategy(PickingStrategy.SIZE_FIX, result);
    }

    SortedMap<PrimaryKey, RangeTree<PrimaryKey, AggregationChunk>> groupByPartition(int partitioningKeyLength) {
        TreeMap<PrimaryKey, RangeTree<PrimaryKey, AggregationChunk>> partitioningKeyToTree = new TreeMap<PrimaryKey, RangeTree<PrimaryKey, AggregationChunk>>();
        Set<AggregationChunk> allChunks = this.prefixRanges[0].getAll();
        for (AggregationChunk chunk : allChunks) {
            PrimaryKey maxKeyPrefix;
            PrimaryKey minKeyPrefix = chunk.getMinPrimaryKey().prefix(partitioningKeyLength);
            if (!minKeyPrefix.equals(maxKeyPrefix = chunk.getMaxPrimaryKey().prefix(partitioningKeyLength))) {
                return null;
            }
            partitioningKeyToTree.computeIfAbsent(minKeyPrefix, $ -> RangeTree.create()).put(chunk.getMinPrimaryKey(), chunk.getMaxPrimaryKey(), chunk);
        }
        return partitioningKeyToTree;
    }

    private List<AggregationChunk> findChunksForPartitioning(int partitioningKeyLength, int maxChunks) {
        ArrayList<AggregationChunk> chunksForPartitioning = new ArrayList<AggregationChunk>();
        ArrayList<AggregationChunk> allChunks = new ArrayList<AggregationChunk>(this.prefixRanges[0].getAll());
        allChunks.sort(MIN_KEY_ASCENDING_COMPARATOR);
        for (AggregationChunk chunk : allChunks) {
            PrimaryKey maxKeyPrefix;
            if (chunksForPartitioning.size() == maxChunks) break;
            PrimaryKey minKeyPrefix = chunk.getMinPrimaryKey().prefix(partitioningKeyLength);
            if (minKeyPrefix.equals(maxKeyPrefix = chunk.getMaxPrimaryKey().prefix(partitioningKeyLength))) continue;
            chunksForPartitioning.add(chunk);
        }
        return chunksForPartitioning;
    }

    public List<AggregationChunk> findChunksForConsolidationMinKey(int maxChunks, int optimalChunkSize) {
        int partitioningKeyLength = this.aggregation.getPartitioningKey().size();
        SortedMap<PrimaryKey, RangeTree<PrimaryKey, AggregationChunk>> partitioningKeyToTree = this.groupByPartition(partitioningKeyLength);
        if (partitioningKeyToTree == null) {
            List<AggregationChunk> chunks = this.findChunksForPartitioning(partitioningKeyLength, maxChunks);
            AggregationState.logChunksAndStrategy(chunks, PickingStrategy.PARTITIONING);
            return chunks;
        }
        PickedChunks pickedChunks = AggregationState.findChunksWithMinKeyOrSizeFixStrategy(partitioningKeyToTree, maxChunks, optimalChunkSize);
        return AggregationState.processSelection(pickedChunks.chunks, maxChunks, pickedChunks.partitionTree, pickedChunks.strategy);
    }

    public List<AggregationChunk> findChunksForConsolidationHotSegment(int maxChunks) {
        RangeTree<PrimaryKey, AggregationChunk> tree = this.prefixRanges[this.aggregation.getKeys().size()];
        List<AggregationChunk> chunks = AggregationState.findChunksGroupWithMostOverlaps(tree);
        return AggregationState.processSelection(chunks, maxChunks, tree, PickingStrategy.HOT_SEGMENT);
    }

    private static List<AggregationChunk> processSelection(List<AggregationChunk> chunks, int maxChunks, RangeTree<PrimaryKey, AggregationChunk> partitionTree, PickingStrategy strategy) {
        if (chunks.isEmpty() || chunks.size() == maxChunks) {
            AggregationState.logChunksAndStrategy(chunks, strategy);
            return chunks;
        }
        if (chunks.size() > maxChunks) {
            List<AggregationChunk> trimmedChunks = AggregationState.trimChunks(chunks, maxChunks);
            AggregationState.logChunksAndStrategy(trimmedChunks, strategy);
            return trimmedChunks;
        }
        if (strategy == PickingStrategy.SIZE_FIX) {
            AggregationState.logChunksAndStrategy(chunks, PickingStrategy.SIZE_FIX);
            return chunks;
        }
        List<AggregationChunk> expandedChunks = AggregationState.expandRange(partitionTree, chunks, maxChunks);
        if (expandedChunks.size() > maxChunks) {
            List<AggregationChunk> trimmedChunks = AggregationState.trimChunks(expandedChunks, maxChunks);
            AggregationState.logChunksAndStrategy(trimmedChunks, strategy);
            return trimmedChunks;
        }
        AggregationState.logChunksAndStrategy(expandedChunks, strategy);
        return expandedChunks;
    }

    private static void logChunksAndStrategy(Collection<AggregationChunk> chunks, PickingStrategy strategy) {
        if (logger.isInfoEnabled()) {
            String chunkIds = chunks.stream().map(AggregationChunk::getChunkId).map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            logger.info("Chunks for consolidation {}: {}. Strategy: {}", new Object[]{chunks.size(), chunkIds, strategy});
        }
    }

    private static List<AggregationChunk> trimChunks(List<AggregationChunk> chunks, int maxChunks) {
        chunks.sort(MIN_KEY_ASCENDING_COMPARATOR);
        return chunks.subList(0, maxChunks);
    }

    private static boolean expandRange(RangeTree<PrimaryKey, AggregationChunk> tree, Set<AggregationChunk> chunks) {
        PrimaryKey minKey = null;
        PrimaryKey maxKey = null;
        for (AggregationChunk chunk : chunks) {
            PrimaryKey chunkMinKey = chunk.getMinPrimaryKey();
            PrimaryKey chunkMaxKey = chunk.getMaxPrimaryKey();
            if (minKey == null) {
                minKey = chunkMinKey;
                maxKey = chunkMaxKey;
                continue;
            }
            if (chunkMinKey.compareTo(minKey) < 0) {
                minKey = chunkMinKey;
            }
            if (chunkMaxKey.compareTo(maxKey) <= 0) continue;
            maxKey = chunkMaxKey;
        }
        Set<AggregationChunk> chunksForRange = tree.getRange(minKey, maxKey);
        return chunks.addAll(chunksForRange);
    }

    private static void expandRange(RangeTree<PrimaryKey, AggregationChunk> tree, Set<AggregationChunk> chunks, int maxChunks) {
        boolean expand;
        boolean bl = expand = chunks.size() < maxChunks;
        while (expand) {
            boolean expanded = AggregationState.expandRange(tree, chunks);
            expand = expanded && chunks.size() < maxChunks;
        }
    }

    private static List<AggregationChunk> expandRange(RangeTree<PrimaryKey, AggregationChunk> tree, List<AggregationChunk> chunks, int maxChunks) {
        HashSet<AggregationChunk> chunkSet = new HashSet<AggregationChunk>(chunks);
        AggregationState.expandRange(tree, chunkSet, maxChunks);
        return new ArrayList<AggregationChunk>(chunkSet);
    }

    public List<ConsolidationDebugInfo> getConsolidationDebugInfo() {
        ArrayList<ConsolidationDebugInfo> infos = new ArrayList<ConsolidationDebugInfo>();
        RangeTree<PrimaryKey, AggregationChunk> tree = this.prefixRanges[this.aggregation.getKeys().size()];
        for (Map.Entry<PrimaryKey, RangeTree.Segment<AggregationChunk>> segmentEntry : tree.getSegments().entrySet()) {
            PrimaryKey key = segmentEntry.getKey();
            RangeTree.Segment<AggregationChunk> segment = segmentEntry.getValue();
            int overlaps = segment.getSet().size() + segment.getClosingSet().size();
            Set<AggregationChunk> segmentSet = segment.getSet();
            Set<AggregationChunk> segmentClosingSet = segment.getClosingSet();
            infos.add(new ConsolidationDebugInfo(key, segmentSet, segmentClosingSet, overlaps));
        }
        return infos;
    }

    public static boolean chunkMightContainQueryValues(PrimaryKey minQueryKey, PrimaryKey maxQueryKey, PrimaryKey minChunkKey, PrimaryKey maxChunkKey) {
        return AggregationState.chunkMightContainQueryValues(minQueryKey.values(), maxQueryKey.values(), minChunkKey.values(), maxChunkKey.values());
    }

    private static boolean chunkMightContainQueryValues(List<Object> queryMinValues, List<Object> queryMaxValues, List<Object> chunkMinValues, List<Object> chunkMaxValues) {
        Checks.checkArgument((queryMinValues.size() == queryMaxValues.size() ? 1 : 0) != 0, (Object)"Sizes of lists of query minimum and maximum values should match");
        Checks.checkArgument((chunkMinValues.size() == chunkMaxValues.size() ? 1 : 0) != 0, (Object)"Sizes of lists of chunk minimum and maximum values should match");
        for (int i = 0; i < queryMinValues.size(); ++i) {
            Comparable chunkMaxValue;
            Comparable queryMinValue = (Comparable)queryMinValues.get(i);
            Comparable queryMaxValue = (Comparable)queryMaxValues.get(i);
            Comparable chunkMinValue = (Comparable)chunkMinValues.get(i);
            if (chunkMinValue.compareTo(chunkMaxValue = (Comparable)chunkMaxValues.get(i)) == 0) {
                if (queryMinValue.compareTo(chunkMinValue) <= 0 && queryMaxValue.compareTo(chunkMaxValue) >= 0) continue;
                return false;
            }
            return queryMinValue.compareTo(chunkMaxValue) <= 0 && queryMaxValue.compareTo(chunkMinValue) >= 0;
        }
        return true;
    }

    public List<AggregationChunk> findChunks(AggregationPredicate predicate, List<String> fields) {
        HashSet<String> requestedFields = new HashSet<String>(fields);
        AggregationPredicates.RangeScan rangeScan = AggregationPredicates.toRangeScan(predicate, this.aggregation.getKeys(), this.aggregation.getKeyTypes());
        ArrayList<AggregationChunk> chunks = new ArrayList<AggregationChunk>();
        for (AggregationChunk chunk : this.rangeQuery(rangeScan.getFrom(), rangeScan.getTo())) {
            if (CollectionUtils.intersection(new HashSet<String>(chunk.getMeasures()), requestedFields).isEmpty()) continue;
            chunks.add(chunk);
        }
        return chunks;
    }

    private List<AggregationChunk> rangeQuery(PrimaryKey minPrimaryKey, PrimaryKey maxPrimaryKey) {
        Checks.checkArgument((minPrimaryKey.size() == maxPrimaryKey.size() ? 1 : 0) != 0, (Object)"Sizes of min primary key and max primary key should match");
        int size = minPrimaryKey.size();
        RangeTree<PrimaryKey, AggregationChunk> index = this.prefixRanges[size];
        return new ArrayList<AggregationChunk>(index.getRange(minPrimaryKey, maxPrimaryKey));
    }

    public String toString() {
        return "Aggregation{keys=" + this.aggregation.getKeys() + ", fields=" + this.aggregation.getMeasures() + '}';
    }

    private static class ChunksAndStrategy {
        private final PickingStrategy strategy;
        private final List<AggregationChunk> chunks;

        public ChunksAndStrategy(PickingStrategy strategy, List<AggregationChunk> chunks) {
            this.strategy = strategy;
            this.chunks = chunks;
        }
    }

    private static class PickedChunks {
        private final PickingStrategy strategy;
        @Nullable
        private final RangeTree<PrimaryKey, AggregationChunk> partitionTree;
        private final List<AggregationChunk> chunks;

        public PickedChunks(PickingStrategy strategy, @Nullable RangeTree<PrimaryKey, AggregationChunk> partitionTree, List<AggregationChunk> chunks) {
            this.strategy = strategy;
            this.partitionTree = partitionTree;
            this.chunks = chunks;
        }
    }

    private static enum PickingStrategy {
        PARTITIONING,
        HOT_SEGMENT,
        MIN_KEY,
        SIZE_FIX;

    }

    public static class ConsolidationDebugInfo {
        public final PrimaryKey key;
        public final Set<AggregationChunk> segmentSet;
        public final Set<AggregationChunk> segmentClosingSet;
        public final int overlaps;

        public ConsolidationDebugInfo(PrimaryKey key, Set<AggregationChunk> segmentSet, Set<AggregationChunk> segmentClosingSet, int overlaps) {
            this.key = key;
            this.segmentSet = segmentSet;
            this.segmentClosingSet = segmentClosingSet;
            this.overlaps = overlaps;
        }
    }
}

