/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.aggregation.AggregationChunk;
import io.activej.aggregation.ChunkIdCodec;
import io.activej.aggregation.PrimaryKey;
import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredCodecs;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.common.exception.parse.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AggregationChunkCodec
implements StructuredCodec<AggregationChunk> {
    private static final StructuredCodec<List<String>> MEASURES_CODEC = StructuredCodecs.STRING_CODEC.ofList();
    public static final String ID = "id";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String COUNT = "count";
    public static final String MEASURES = "measures";
    private final ChunkIdCodec<Object> chunkIdCodec;
    private final StructuredCodec<PrimaryKey> primaryKeyCodec;
    private final Set<String> allowedMeasures;

    private AggregationChunkCodec(ChunkIdCodec<?> chunkIdCodec, StructuredCodec<PrimaryKey> primaryKeyCodec, Set<String> allowedMeasures) {
        this.chunkIdCodec = chunkIdCodec;
        this.primaryKeyCodec = primaryKeyCodec;
        this.allowedMeasures = allowedMeasures;
    }

    public static AggregationChunkCodec create(ChunkIdCodec<?> chunkIdCodec, StructuredCodec<PrimaryKey> primaryKeyCodec, Set<String> allowedMeasures) {
        return new AggregationChunkCodec(chunkIdCodec, primaryKeyCodec, allowedMeasures);
    }

    public void encode(StructuredOutput out, AggregationChunk chunk) {
        out.writeObject(() -> {
            out.writeKey(ID);
            this.chunkIdCodec.encode(out, chunk.getChunkId());
            out.writeKey(MIN);
            this.primaryKeyCodec.encode(out, (Object)chunk.getMinPrimaryKey());
            out.writeKey(MAX);
            this.primaryKeyCodec.encode(out, (Object)chunk.getMaxPrimaryKey());
            out.writeKey(COUNT);
            out.writeInt(chunk.getCount());
            out.writeKey(MEASURES);
            MEASURES_CODEC.encode(out, chunk.getMeasures());
        });
    }

    public AggregationChunk decode(StructuredInput in) throws ParseException {
        return (AggregationChunk)in.readObject($ -> {
            in.readKey(ID);
            Object id = this.chunkIdCodec.decode(in);
            in.readKey(MIN);
            PrimaryKey from = (PrimaryKey)this.primaryKeyCodec.decode(in);
            in.readKey(MAX);
            PrimaryKey to = (PrimaryKey)this.primaryKeyCodec.decode(in);
            in.readKey(COUNT);
            int count = in.readInt();
            in.readKey(MEASURES);
            List measures = (List)MEASURES_CODEC.decode(in);
            List<String> invalidMeasures = this.getInvalidMeasures(measures);
            if (!invalidMeasures.isEmpty()) {
                throw new ParseException("Unknown fields: " + invalidMeasures);
            }
            return AggregationChunk.create(id, measures, from, to, count);
        });
    }

    private List<String> getInvalidMeasures(List<String> measures) {
        ArrayList<String> invalidMeasures = new ArrayList<String>();
        for (String measure : measures) {
            if (this.allowedMeasures.contains(measure)) continue;
            invalidMeasures.add(measure);
        }
        return invalidMeasures;
    }
}

